package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 核销方式枚举类
 * @author wanghaojia
 * @date 2022/11/25 10:01
 */
@Getter
@AllArgsConstructor
public enum SubComActivityDetailAuditTypeEnum {

    THINGS("1","事中","SZ"),
    AFTER_THE_EVENT("2","事后","SH"),
    ;

    private final String code;

    private final String name;

    private final String des;

    public static String codeToName(String code) {
        if (StringUtils.isBlank(code)) {
            return "";
        }
        SubComActivityDetailAuditTypeEnum auditTypeEnum = null;
        SubComActivityDetailAuditTypeEnum[] var2 = values();

        for (SubComActivityDetailAuditTypeEnum typeEnum : var2) {
            if (typeEnum.code.equals(code)) {
                auditTypeEnum = typeEnum;
            }
        }

        return null == auditTypeEnum ? "" : auditTypeEnum.getName();
    }
}
