package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums;

import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanModifyPassMqTagConstant;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 分子公司细案变更审批通过调用mq tag枚举
 * @author wanghaojia
 * @date 2023/1/16 21:00
 */
@AllArgsConstructor
@Getter
public enum SubComActivityDetailPlanModifyPassMqTagEnum {

    PASS_UPDATE_PLAN(SubComActivityDetailPlanModifyPassMqTagConstant.PASS_UPDATE_PLAN,"分子活动细案变更审批通过更新细案数据", PushType.code),
    //更新SD数据放在原数据更新完之后调用
    PASS_UPDATE_SD(SubComActivityDetailPlanModifyPassMqTagConstant.PASS_UPDATE_SD,"分子公司细案变更审批通过推送sd", PushType.after_update_plan),
    PASS_UPDATE_ORDER_SHARE(SubComActivityDetailPlanModifyPassMqTagConstant.PASS_UPDATE_ORDER_SHARE,"分子公司细案变更审批通过推送订单共享", PushType.after_update_plan),
    ;

    private final String code;

    private final String name;

    private final PushType pushType;

    public enum PushType{
        data,code,after_update_plan
    }

}
