package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums;

import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanPassMqTagConstant;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 活动方案审批通过调用mq tag枚举
 * @author wanghaojia
 * @date 2023/1/16 21:00
 */
@AllArgsConstructor
@Getter
public enum SubComActivityDetailPlanPassMqTagEnum {

    PASS_SAP_SD(SubComActivityDetailPlanPassMqTagConstant.PASS_SAP_SD,"分子活动细案审批通过推送SD",PushType.code),
    PASS_ORDER_SHARE(SubComActivityDetailPlanPassMqTagConstant.PASS_ORDER_SHARE,"分子活动细案审批通过推送订单共享平台",PushType.code),
    PASS_MATERIAL_PURCHASING_ORDER(SubComActivityDetailPlanPassMqTagConstant.PASS_MATERIAL_PURCHASING_ORDER,"分子活动细案审批通过推送物料采购单",PushType.code),
    PASS_DETAILED_FORECAST(SubComActivityDetailPlanPassMqTagConstant.PASS_DETAILED_FORECAST,"分子活动细案审批通过推送细案预测表",PushType.code),
    MODIFY_PASS_MATERIAL_PURCHASING_ORDER(SubComActivityDetailPlanPassMqTagConstant.MODIFY_PASS_MATERIAL_PURCHASING_ORDER,"分子活动细案变更审批通过推送物料采购单",PushType.code),
    PASS_AUDIT_FEE_PREDICTION(SubComActivityDetailPlanPassMqTagConstant.PASS_AUDIT_FEE_PREDICTION,"分子活动细案审批通过推送扣费预测",PushType.code),
    ;

    private final String code;

    private final String name;

    private final PushType pushType;

    public enum PushType{
        data,code
    }

}
