package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 订单共享平台
 * @author : qiancheng
 * @date : 2022-12-27
 */
public enum ThirdSystemActivityStatusEnum {

    /**
     * 细案明细推送订单共享平台、SAP —— 活动状态
     */
    VALID("1","有效"),
    INVALID("2","无效"),

    /**
     * 回调结果
     */
    SUCCESS("S","成功"),
    FAIL("E","失败");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    private ThirdSystemActivityStatusEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static Set<String> codeToSet() {
        Set<String> codes = new HashSet();
        ThirdSystemActivityStatusEnum[] var1 = values();
        int var2 = var1.length;

        for(int var3 = 0; var3 < var2; ++var3) {
            ThirdSystemActivityStatusEnum orderShareActivityStatusEnum = var1[var3];
            codes.add(orderShareActivityStatusEnum.getCode());
        }

        return codes;
    }

    public static ThirdSystemActivityStatusEnum codeToEnum(String code) {
        ThirdSystemActivityStatusEnum orderShareActivityStatus = null;
        ThirdSystemActivityStatusEnum[] var2 = values();
        int var3 = var2.length;

        for(int var4 = 0; var4 < var3; ++var4) {
            ThirdSystemActivityStatusEnum orderShareActivityStatusEnum = var2[var4];
            if (orderShareActivityStatusEnum.code.equals(code)) {
                orderShareActivityStatus = orderShareActivityStatusEnum;
            }
        }

        return orderShareActivityStatus;
    }

    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            ThirdSystemActivityStatusEnum[] values = values();
            ThirdSystemActivityStatusEnum[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                ThirdSystemActivityStatusEnum value = var2[var4];
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }

        return null;
    }

    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        } else {
            ThirdSystemActivityStatusEnum[] values = values();
            ThirdSystemActivityStatusEnum[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                ThirdSystemActivityStatusEnum value = var2[var4];
                if (value.getCode().equals(code)) {
                    return true;
                }
            }

            return false;
        }
    }

}
