package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.event;

import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanBudgetVo;

import java.util.List;

/**
 * 分子公司活动细案预算变更事件通知接口
 *
 * @author makejava
 * @date 2022-11-28 15:28:32
 */
public interface SubComActivityDetailPlanBudgetEventListener {

    /**
     * 创建时触发
     *
     * @param vo
     */
    void onCreate(SubComActivityDetailPlanBudgetDto vo);

    /**
     * 编辑时触发
     *
     * @param oldVo
     * @param newVo
     */
    void onUpdate(SubComActivityDetailPlanBudgetVo oldVo, SubComActivityDetailPlanBudgetDto newVo);

    /**
     * 启用时触发
     *
     * @param list
     */
    void onEnable(List<SubComActivityDetailPlanBudgetVo> list);


    /**
     * 禁用时触发
     *
     * @param list
     */
    void onDisable(List<SubComActivityDetailPlanBudgetVo> list);

    /**
     * 删除时触发
     *
     * @param list
     */
    void onDelete(List<SubComActivityDetailPlanBudgetVo> list);
}

