package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.event;

import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;

import java.util.List;

/**
 * 分子公司活动细案变更事件通知接口
 *
 * @author makejava
 * @date 2022-11-28 15:28:18
 */
public interface SubComActivityDetailPlanEventListener {

    /**
     * 创建时触发
     *
     * @param vo 分子公司细案vo
     */
    void onCreate(SubComActivityDetailPlanDto vo);

    /**
     * 编辑时触发
     *
     * @param oldVo 旧的分子公司细案vo
     * @param newVo 新的分子公司细案vo
     */
    void onUpdate(SubComActivityDetailPlanVo oldVo, SubComActivityDetailPlanDto newVo);

    /**
     * 启用时触发
     *
     * @param list 分子公司细案vo集合
     */
    void onEnable(List<SubComActivityDetailPlanVo> list);


    /**
     * 禁用时触发
     *
     * @param list 分子公司细案vo集合
     */
    void onDisable(List<SubComActivityDetailPlanVo> list);

    /**
     * 删除时触发
     *
     * @param list 分子公司细案vo集合
     */
    void onDelete(List<SubComActivityDetailPlanVo> list);


    /**
     * 关闭时触发
     *
     * @param list 分子公司细案vo集合
     */
    void onClose(List<SubComActivityDetailPlanVo> list);


    /**
     * 修改审批状态时触发
     * @param detail 分子公司细案vo
     * @param processStatus 审批状态
     */
    void onUpdateProcessStatus(SubComActivityDetailPlanVo detail, String processStatus);
}

