package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.event;

import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;

import java.util.List;

/**
 * 分子公司活动细案变更事件通知接口
 *
 * @author makejava
 * @date 2022-11-28 15:28:54
 */
public interface SubComActivityDetailPlanItemEventListener {

    /**
     * 创建时触发
     *
     * @param vo
     */
    void onCreate(SubComActivityDetailPlanItemDto vo);

    /**
     * 编辑时触发
     *
     * @param oldVo
     * @param newVo
     */
    void onUpdate(SubComActivityDetailPlanItemVo oldVo, SubComActivityDetailPlanItemDto newVo);

    /**
     * 启用时触发
     *
     * @param list
     */
    void onEnable(List<SubComActivityDetailPlanItemVo> list);


    /**
     * 禁用时触发
     *
     * @param list
     */
    void onDisable(List<SubComActivityDetailPlanItemVo> list);

    /**
     * 删除时触发
     *
     * @param list
     */
    void onDelete(List<SubComActivityDetailPlanItemVo> list);

    /**
     * 关闭时触发
     *
     * @param vo
     */
    void onClose(SubComActivityDetailPlanItemVo vo);

}

