package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.event;

import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemFileDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemFileVo;

import java.util.List;

/**
 * 分子公司活动细案预算变更事件通知接口
 *
 * @author makejava
 * @date 2022-11-28 16:01:04
 */
public interface SubComActivityDetailPlanItemFileEventListener {

    /**
     * 创建时触发
     *
     * @param vo
     */
    void onCreate(SubComActivityDetailPlanItemFileDto vo);

    /**
     * 编辑时触发
     *
     * @param oldVo
     * @param newVo
     */
    void onUpdate(SubComActivityDetailPlanItemFileVo oldVo, SubComActivityDetailPlanItemFileDto newVo);

    /**
     * 启用时触发
     *
     * @param list
     */
    void onEnable(List<SubComActivityDetailPlanItemFileVo> list);


    /**
     * 禁用时触发
     *
     * @param list
     */
    void onDisable(List<SubComActivityDetailPlanItemFileVo> list);

    /**
     * 删除时触发
     *
     * @param list
     */
    void onDelete(List<SubComActivityDetailPlanItemFileVo> list);
}

