package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service;

import java.util.List;

/**
 * 分子公司活动细案-促销活动 推送 第三方服务
 *
 * @author qiancheng
 * @since 2023-01-14
 */
public interface PushSubActivityToThirdSystemService {


    /**
     * ======================= 订单共享平台 ==============================================
     */

    /**
     * 促销活动创建 ——订单共享平台
     *
     * @param planCodes 分子公司活动细案编码集合
     */
    void createActivityPushOrderShare(List<String> planCodes);

    /**
     * 促销活动变更（活动量、活动金额、有效期） —— 订单共享平台。
     *
     * @param planCodes 分子公司活动细案编码集合
     */
    void updateActivityPushOrderShare(List<String> planCodes);

    /**
     * 促销活动变更（活动量、活动金额、有效期） —— 订单共享平台。
     *
     * @param planCodes 分子公司活动细案明细编码集合
     */
    void updateActivityPushOrderShareByItemCodes(List<String> planItemCodes);

    /**
     * 促销活动关闭 —— 订单共享平台
     *
     * @param itemCodes 明细编码集合
     */
    void closeActivityPushOrderShare(List<String> itemCodes);


    /**
     * ========================== SAP ==================================================
     */

    /**
     * 促销活动创建——SAP——分公司
     *
     * @param planCodes 分子公司活动细案编码集合
     * @return
     */
    void createActivityPushSapBranch(List<String> planCodes);

    /**
     * 促销活动变更/关闭——SAP——分公司
     *
     * @param itemCodes 明细编码集合
     * @param close 活动是否关闭 true：关闭
     * @return
     */
    void updateActivityPushSapBranch(List<String> itemCodes,boolean close);


    void closePushThirdSystemAsync(List<String> codeList);
}
