package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanBudgetVo;
import org.springframework.data.domain.Pageable;

/**
 * 分子公司活动细案预算(ActivityConstituentDetailPlanBudget)表服务接口
 *
 * @author makejava
 * @date 2022-11-28 15:28:32
 */
public interface SubComActivityDetailPlanBudgetVoService {

    /**
     * 分页条件查询
     *
     * @param pageable 分页参数
     * @param dto 查询提交
     * @return 分子公司预算vo列表
     */
    Page<SubComActivityDetailPlanBudgetVo> findByConditions(Pageable pageable, SubComActivityDetailPlanBudgetDto dto);

    /**
     * 按id查询详情
     *
     * @param id 主键
     * @return 分子公司预算vo
     */
    SubComActivityDetailPlanBudgetVo findDetailById(String id);

    /**
     * 创建
     *
     * @param dto 分子公司预算vo
     * @return 更新后的分子公司预算vo
     */
    void create(SubComActivityDetailPlanBudgetDto dto);

    /**
     * 更新
     *
     * @param activityConstituentDetailPlanBudgetVo 分子公司预算vo
     * @return 更新后的分子公司预算vo
     */
    void update(SubComActivityDetailPlanBudgetDto activityConstituentDetailPlanBudgetVo);

    /**
     * 按id集合启用
     *
     * @param ids 主键集合
     */
    void enableBatch(List<String> ids);

    /**
     * 按id集合禁用
     *
     * @param ids 主键集合
     */
    void disableBatch(List<String> ids);

    /**
     * 逻辑删除
     *
     * @param ids 主键集合
     */
    void updateDelFlagByIds(List<String> ids);


    /**
     * 根据分子公司细案编码逻辑删除
     * @param planCode  分子公司编码
     */
    void updateDelFlagByPlanCode(String planCode);


    /**
     * 根据分子公司细案编码获取分子公司预算列表
     * @param constituentDetailPlanCode 分子公司细案编码
     * @return  分子公司预算列表
     */
    List<SubComActivityDetailPlanBudgetVo> findDetailByPlanCode(String constituentDetailPlanCode);

    List<SubComActivityDetailPlanBudgetVo> findDetailByPlanCodes(List<String> constituentDetailPlanCodes);

}
