package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemBudgetShareDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemBudgetShareVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 分子公司活动细案明细预算分摊明细(SubComActivityDetailPlanItemBudgetShare)表服务接口
 *
 * @author makejava
 * @date 2022-11-29 16:54:05
 */
public interface SubComActivityDetailPlanItemBudgetShareVoService {

    /**
     * 分页条件查询
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<SubComActivityDetailPlanItemBudgetShareVo> findByConditions(Pageable pageable, SubComActivityDetailPlanItemBudgetShareDto dto);

    /**
     * 按id查询详情
     *
     * @param id
     * @return
     */
    SubComActivityDetailPlanItemBudgetShareVo findDetailById(String id);


    /**
     * 根据分子公司明细编码获取分摊预算信息
     * @param itemPlanCode 分子公司明细编码
     * @return  分摊预算信息列表
     */
    List<SubComActivityDetailPlanItemBudgetShareVo> findDetailByPlanItemCode(String itemPlanCode);

    /**
     * 创建
     *
     * @param subComActivityDetailPlanItemBudgetShareVo
     * @return
     */
    void create(SubComActivityDetailPlanItemBudgetShareDto subComActivityDetailPlanItemBudgetShareVo);

    /**
     * 更新
     *
     * @param subComActivityDetailPlanItemBudgetShareVo
     * @return
     */
    void update(SubComActivityDetailPlanItemBudgetShareDto subComActivityDetailPlanItemBudgetShareVo);

    /**
     * 按id集合启用
     *
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 按id集合禁用
     *
     * @param ids
     */
    void disableBatch(List<String> ids);

    /**
     * 逻辑删除
     *
     * @param ids
     */
    void updateDelFlagByIds(List<String> ids);

    void updateDelFlagByPlanCode(String planCode);

    /**
     * 根据分子公司细案明细编码逻辑删除
     * @param planItemCode 分子公司细案明细编码
     */
    void updateDelFlagByPlanItemCode(String planItemCode);

    /**
     * 根据code查询明细
     * @param constituentDetailPlanCode
     */
    List<SubComActivityDetailPlanItemBudgetShareVo> findConstituentDetailPlanCode(String constituentDetailPlanCode);

    /**
     * 分公司细案预算扣减
     * @param constituentDetailPlanCodeList 分公司细案编码
     * @return
     */
    List<String> useMonthBudgetByCode(List<String> constituentDetailPlanCodeList);

    /**
     * 退回月度预算
     * @param constituentDetailPlanCodeList
     * @return
     */
    List<String> returnMonthBudgetByPlanCodeList(List<String> constituentDetailPlanCodeList);

    List<SubComActivityDetailPlanItemBudgetShareVo> findDetailByPlanItemCodes(List<String> detailItemCodes);
}
