package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemFileDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemFileVo;
import org.springframework.data.domain.Pageable;

/**
 * 分子公司活动细案预算(ActivityConstituentDetailPlanItemFile)表服务接口
 *
 * @author makejava
 * @date 2022-11-28 16:01:04
 */
public interface SubComActivityDetailPlanItemFileVoService {

    /**
     * 分页条件查询
     *
     * @param pageable 分页参数
     * @param dto 查询条件
     * @return 分子公司细案明细附件Vo列表
     */
    Page<SubComActivityDetailPlanItemFileVo> findByConditions(Pageable pageable, SubComActivityDetailPlanItemFileDto dto);

    /**
     * 按id查询详情
     *
     * @param id 主键
     * @return  分子公司细案明细附件Vo
     */
    SubComActivityDetailPlanItemFileVo findDetailById(String id);


    /**
     * 按分子公司细案明细编码查询详情
     * @param planItemCode 分子公司细案明细编码
     * @return 分子公司细案明细附件Vo
     */
    List<SubComActivityDetailPlanItemFileVo> findDetailByPlanItemCode(String planItemCode);

    /**
     * 创建
     *
     * @param activityConstituentDetailPlanItemFileVo 分子公司细案明细附件Vo
     * @return 更新后分子公司细案明细附件Vo
     */
    void create(SubComActivityDetailPlanItemFileDto activityConstituentDetailPlanItemFileVo);

    /**
     * 更新
     *
     * @param activityConstituentDetailPlanItemFileVo   分子公司细案明细附件Vo
     * @return 更新后分子公司细案明细附件Vo
     */
    void update(SubComActivityDetailPlanItemFileDto activityConstituentDetailPlanItemFileVo);

    /**
     * 按id集合删除
     *
     * @param ids 主键集合
     */
    void removeByIds(List<String> ids);

    void removeByPlanCode(String planCode);

    /**
     * 按分子公司细案明细编码删除
     *
     * @param planItemCode 分子公司细案明细编码
     */
    void removeByPlanItemCode(String planItemCode);


}
