package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemProductShareDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemProductShareVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * 分子公司活动细案明细产品分摊明细(SubComActivityDetailPlanItemProductShare)表服务接口
 *
 * @author makejava
 * @date 2022-11-29 16:55:23
 */
public interface SubComActivityDetailPlanItemProductShareVoService {

    /**
     * 分页条件查询
     *
     * @param pageable 分页参数
     * @param dto 条件
     * @return 分子公司细案产品分摊vo列表
     */
    Page<SubComActivityDetailPlanItemProductShareVo> findByConditions(Pageable pageable, SubComActivityDetailPlanItemProductShareDto dto);

    /**
     * 按id查询分子公司产品分摊详情
     *
     * @param id 主键id
     * @return 分子公司细案产品分摊vo
     */
    SubComActivityDetailPlanItemProductShareVo findDetailById(String id);


    /**
     * 根据分子公司明细编码获取产品分摊信息
     * @param itemPlanCode 分子公司明细编码
     * @return  分摊产品信息列表
     */
    List<SubComActivityDetailPlanItemProductShareVo> findDetailByPlanItemCode(String itemPlanCode);

    /**
     * 创建
     *
     * @param subComActivityDetailPlanItemProductShareVo 分子公司细案产品分摊vo
     * @return 更新后的分子公司细案产品分摊vo
     */
    void create(SubComActivityDetailPlanItemProductShareDto subComActivityDetailPlanItemProductShareVo);

    /**
     * 更新
     *
     * @param subComActivityDetailPlanItemProductShareVo 分子公司细案产品分摊vo
     * @return 更新后的分子公司细案产品分摊vo
     */
    void update(SubComActivityDetailPlanItemProductShareDto subComActivityDetailPlanItemProductShareVo);

    /**
     * 按id集合启用
     *
     * @param ids 主键id
     */
    void enableBatch(List<String> ids);

    /**
     * 按id集合禁用
     *
     * @param ids 主键id
     */
    void disableBatch(List<String> ids);

    /**
     * 逻辑删除
     *
     * @param ids 主键id
     */
    void updateDelFlagByIds(List<String> ids);

    void updateDelFlagByPlanCode(String planCode);

    /**
     * 根据分子公司细案明细编码逻辑删除产品分摊信息
     * @param constituentDetailPlanItemCode 分子公司细案明细编码
     */
    void updateDelFlagByPlanItemCode(String constituentDetailPlanItemCode);


    /**
     * 根据分子公司细案明细获取产品分摊信息
     * @param items 分子公司细案明细列表
     */
    List<SubComActivityDetailPlanItemProductShareVo> findListByItem(SubComActivityDetailPlanItemVo item);


    Page<SubComActivityDetailPlanItemProductShareVo> findListByItemPage(Pageable pageable,SubComActivityDetailPlanItemVo item);

    /**
     * 查询分摊产品
     * @param activityDetailCodeSet
     * @return
     */
    List<SubComActivityDetailPlanItemProductShareVo> findApportionProductByActivityDetailCodes(Set<String> activityDetailCodeSet);
}
