package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.*;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 分子公司活动细案(ActivityConstituentDetailPlanItem)表服务接口
 *
 * @author makejava
 * @date 2022-11-28 15:28:54
 */
public interface SubComActivityDetailPlanItemVoService {

    /**
     * 分页条件查询
     *
     * @param pageable 分页参数
     * @param dto      查询条件
     * @return 分子公司细案明细VO集合
     */
    Page<SubComActivityDetailPlanItemVo> findByConditions(Pageable pageable, SubComActivityDetailPlanItemDto dto);

    /**
     * 按id查询详情
     *
     * @param id 主键
     * @return 分子公司细案明细VO
     */
    SubComActivityDetailPlanItemVo findDetailById(String id);

    /**
     * 按id查询详情
     *
     * @param itemCode 明细编码
     * @return 分子公司细案明细VO
     */
    SubComActivityDetailPlanItemVo findDetailByItemCode(String itemCode);

    /**
     * 根据分子公司细案编码获取明细列表
     *
     * @param planCode 分子公司细案编码
     * @return 分子公司细案明细集合
     */
    List<SubComActivityDetailPlanItemVo> findDetailByPlanCode(String planCode);

    List<SubComActivityDetailPlanItemVo> findDetailByPlanCodes(List<String> planCodes);

    List<SubComActivityDetailPlanItemVo> findDetailByItemCodeList(List<String> itemCodeList);

    /**
     * 根据分子公司细案编码获取明细列表
     *
     * @param detailPlanCode 分子公司细案明细编码
     * @return 分子公司细案明细集合
     */
    List<SubComActivityDetailPlanItemVo> findDetailByPlanItemCode(String detailPlanCode);

    /**
     * 根据分子公司细案明细编码集合获取明细
     *
     * @param detailPlanItemCodes 明细编码集合
     * @return 明细集合
     */
    List<SubComActivityDetailPlanItemVo> findItemsByPlanItemCodes(List<String> detailPlanItemCodes);

    /**
     * 创建
     *
     * @param activityConstituentDetailPlanItemVo 分子公司细案明细VO
     * @return 更新后的分子公司细案明细VO
     */
    void create(SubComActivityDetailPlanItemDto activityConstituentDetailPlanItemVo);

    /**
     * 更新
     *
     * @param activityConstituentDetailPlanItemVo 分子公司细案明细VO
     * @return 更新后的分子公司细案明细VO
     */
    void update(SubComActivityDetailPlanItemDto activityConstituentDetailPlanItemVo);

    /**
     * 按id集合启用
     *
     * @param ids 主键列表
     */
    void enableBatch(List<String> ids);

    /**
     * 按id集合禁用
     *
     * @param ids 主键列表
     */
    void disableBatch(List<String> ids);

    /**
     * 逻辑删除
     *
     * @param ids 主键列表
     */
    void updateDelFlagByIds(List<String> ids);

    /**
     * 根据主键id关闭分子公司细案明细
     *
     * @param
     */
    void closeById(SubComActivityDetailPlanItemDto dto);


    /**
     * 结案核销修改已结案金额和是否完全结案标识
     *
     * @param dtoList
     */
    void changeSonActivityDetailAuditInfo(List<SubComActivityDetailPlanItemDto> dtoList);

    /**
     * 生成促销力度监控数据,查询数据量
     *
     * @param tenantCode 租户编码
     * @return int
     */
    int getMonitorDataCount(String tenantCode);

    /**
     * 分页查询监控数据
     *
     * @param pageable       页
     * @param tenantCode 租户编码
     * @return List<SubComActivityDetailPlanMonitorVo>
     */
    Page<SubComActivityDetailPlanMonitorVo> getMonitorData(Pageable pageable, String tenantCode);

    /**
     * 更新明细推送订单共享状态
     *
     * @param itemCode 明细编码集合
     * @param success 成功标记
     */
    void updatePlanItemPushOrderShareStatus(List<String> itemCode, boolean success);

    /**
     * 批量更新明细推送sap状态
     *
     * @param itemCode 明细编码
     * @Param success 成功标记
     */
    void updateDetailPlanItemPushSapStatus(String itemCode,boolean success);

    /**
     * 删除不存在的数据
     */
    void deleteByPlanCodeAndIdNotIn(String constituentDetailPlanCode, List<String> idList);

    Page<SubComActivityDetailPlanItemVo> findForWithholding(Pageable subComPageable, SubComActivityDetailPlanItemDto downwardDto);

    List<SubComActivityDetailPlanItemVo> findDetailByPlanItemCodeList(Set<String> downwardDetailItemCodeSet);

    /**
     * 根据细案编码集合 批量查询明细
     * @param detailPlanCodes 细案编码集合
     * @return 明细集合
     */
    List<SubComActivityDetailPlanItemVo> findItemsByDetailPlanCodes(List<String> detailPlanCodes);

    /**
     * 根据缓存获取总费用
     *
     * @param cacheKey 缓存key
     * @return 统计表详情
     */
    BigDecimal getApplyAmount(String cacheKey, String constituentDetailPlanCode);

    /**
     * 更据促销活动号查询明细集合
     * @param promotionNoSet  促销活动号集合
     * @return 明细集合
     */
    List<SubComActivityDetailPlanItemVo> findItemsByPromotionNos(Set<String> promotionNoSet);

    /**
     * 批量校验
     */
    void validationList(List<SubComActivityDetailPlanItemDto> itemList);


    /**
     * 获取客户列表
     *
     * @param subComActivityDetailPlanItemDto 请求dto
     * @return {@link Set}<{@link String}>
     */
    Set<String> findCustomer(SubComActivityDetailPlanItemDto subComActivityDetailPlanItemDto);

    /**
     * 找到通过客户编码
     *
     * @param subComActivityDetailPlanItemDto 分子公司明细dto
     * @return {@link List}<{@link SubComActivityDetailPlanItemVo}>
     */
    List<SubComActivityDetailPlanItemVo> findByCustomerCode(SubComActivityDetailPlanItemDto subComActivityDetailPlanItemDto);

    Map<String,List<SubComActivityDetailPlanItemVo>> findSameActivityWithNumber(List<String> numberList);

    /**
     * 查询总条数
     * @param subComActivityDetailPlanItemDto
     * @return
     */
    int findTotalByConditions(SubComActivityDetailPlanItemDto subComActivityDetailPlanItemDto);

    List<SubComActivityDetailPlanItemBudgetShareVo> findDetailBudgetByItemCodeList(List<String> detailItemCodes);

    /**
     * 查询可核销数据
     * @param autoAuditParams 查询参数
     * @return List
     */
    Page<SubComActivityDetailPlanItemVo> findCanAutoAuditSubComItemPage(Pageable pageable, AutoAuditParamsDto autoAuditParams);


    /**
     * 更据商超扣费映射配置的维度 查询匹配的活动明细总条数
     *
     * @param selectDto
     * @return
     */
    Integer getExtractAuditDetailPlanCheckDataTotal(SubComActivityDetailPlanItemDto selectDto);

    /**
     * 更据商超扣费映射配置的维度 查询匹配的活动明细详情
     *
     * @param selectDto
     * @param pageNumber
     * @param pageSize
     * @return
     */
    List<SubComActivityDetailPlanItemVo> extractAuditDetailPlanCheckData(SubComActivityDetailPlanItemDto selectDto, int pageNumber, int pageSize);

    /**
     * 对账单管理查询分子活动细案明细
     *
     * @param pageable
     * @param customerCode 客户编码
     * @return
     */
    Page<SubComActivityDetailPlanItemVo> findDetailPlanItemForKmsReconciliation(Pageable pageable, String customerCode);

    Page<DetailedAccountOfActivityVo> findDetailedAccountOfActivityPage(Pageable pageable, DetailedAccountOfActivityVo dto);

    /**
     * 促销进度、力度执行监控查询
     * @param pageable
     * @param dto
     * @return
     */
    Page<SubComActivityDetailPlanItemVo> findByConditionsForPromotionExecuteMonitoring(Pageable pageable, SubComActivityDetailPlanItemDto dto);

    /**
     * 根据向上细案编码获取总部支持金额汇总
     * @param dto
     * @return
     */
    List<SubComActivityDetailPlanItemVo> findSupportedAmount(SubComActivityDetailPlanItemDto dto);

    Page<SubComActivityDetailPlanItemVo> saleAndFeeMonitoringByConditions(Pageable pageable, SubComActivityDetailPlanItemDto dto2);

    /**
     * 规划变更-更新细案
     * @param itemList
     */
    void updateItemByDesignModify(List<SubComActivityDetailPlanItemDto> itemList);

    /**
     * 查询（费用预测用）
     * @param pageable
     * @param itemDto
     * @return
     */
    Page<String> findByDtoForPrediction(Pageable pageable, SubComActivityDetailPlanItemDto itemDto);

    /**
     * 更新商超自动自动匹配使用费用
     * @param item
     */
    void useProductNumber(SubComActivityDetailPlanItemVo item);


    Page<ActivityDetailManageOneProductFeeVo> findPageItemForManageOneProductFee(Pageable pageable, int year, String companyCode, String productCode);

    Page<ActivityDetailManageActivityTypeFeeVo> findPageItemForManageActivityTypeFee(Pageable pageable, int year);

    Page<ActivityDetailManageChannelFeeVo> findPageItemForManageChannelFee(Pageable pageable, int year);

    Page<AuditDetailSonCompanyBudgetWarnVo> findPageItemForSonCompanyBudgetWarn(Pageable pageable, int year, int month);
}
