package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.*;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.PrePaySubComActivityVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemBudgetShareVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanPlanVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 分子公司活动细案(ActivityConstituentDetailPlan)表服务接口
 *
 * @author makejava
 * @date 2022-11-28 15:28:19
 */
public interface SubComActivityDetailPlanVoService {

    /**
     * 分页条件查询
     *
     * @param pageable 分页参数
     * @param dto 查询条件
     * @return 分子公司细案vo集合
     */
    Page<SubComActivityDetailPlanVo> findByConditions(Pageable pageable, SubComActivityDetailPlanDto dto);



    /**
     * 活动预付获取分子公司活动明细(分页)
     * @param dto
     * @return
     */
    Page<PrePaySubComActivityVo> findSubComActivityDetailPage(Pageable pageable,PrePaySubComActivityDto dto);


    /**
     * 按id查询详情
     *
     * @param id 主键
     * @return 分子公司细案vo
     */
    SubComActivityDetailPlanVo findDetailById(String id);

    List<SubComActivityDetailPlanVo> findDetailByIdList(List<String> idList);

    /**
     * 按分子公司细案编码查询详情
     *
     * @param planCode 细案编码
     * @return 分子公司细案vo
     */
    SubComActivityDetailPlanVo findDetailByPlanCode(String planCode);

    List<SubComActivityDetailPlanVo> findDetailByPlanCodes(List<String> planCodes);

    /**
     * 按分子公司细案编码查询细案及明细详情
     *
     * @param planCodes 细案编码
     * @return 分子公司细案vo
     */
    List<SubComActivityDetailPlanVo> findDetailPlanAndItemByPlanCode(List<String> planCodes);

    /**
     * 按分子公司细案编码查询细案及明细详情
     *
     * @param planCodes 细案编码
     * @return 分子公司细案vo
     */
    List<SubComActivityDetailPlanVo> findAllDetailPlanAndItemByPlanCode(List<String> planCodes);

    /**
     * 创建
     *
     * @param activityConstituentDetailPlanVo 分子公司细案vo
     * @return 更新后的分子公司细案vo
     */
    String create(String cacheKey,SubComActivityDetailPlanDto activityConstituentDetailPlanVo);
    /**
     * 创建
     *
     * @param activityConstituentDetailPlanVo 分子公司细案vo
     * @return 更新后的分子公司细案vo
     */
    String create(SubComActivityDetailPlanDto activityConstituentDetailPlanVo, List<SubComActivityDetailPlanItemDto> itemList);

    /**
     * 更新
     *
     * @param activityConstituentDetailPlanVo 分子公司细案vo
     * @return 更新后的分子公司细案vo
     */
    void update(String cacheKey,SubComActivityDetailPlanDto activityConstituentDetailPlanVo);

    /**
     * 按id集合启用
     *
     * @param ids 主键集合
     */
    void enableBatch(List<String> ids);

    /**
     * 按id集合禁用
     *
     * @param ids 主键集合
     */
    void disableBatch(List<String> ids);

    /**
     * 逻辑删除
     *
     * @param ids 主键集合
     */
    void updateDelFlagByIds(List<String> ids);

    /**
     *
     * @param
     * @return 分子公司细案关闭结果
     */
    Map<String, String> closeBatch(List<SubComActivityDetailPlanItemDto> list);

    void submit(SubComActivityDetailPlanDto subComActivityDetailPlanVo);

    /**
     * 分子公司活动细案提交审批
     *
     */
    void submitApproval(SubComActivityDetailPlanApproveSubmitDto dto);


    /**
     * 分页获取可以关联的方案、细案
     */
    Page<SubComActivityDetailPlanPlanVo> findCanRelationPlanListPage(Pageable pageable, SubComActivityDetailPlanPlanDto dto);

    /**
     * 获取可核销数据
     * @return List
     */
    List<SubComActivityDetailPlanVo> findSubComAutoAudits(Page<SubComActivityDetailPlanVo> page, String autoDate);

    int getSubComTotal(String autoDate);

    /**
     * 修改标识
     * @param codeList 编码集合
     * @param autoAuditFlag 标记
     */
    void updateSubComAutoAudit(List<String>  codeList,String autoAuditFlag);

    List<SubComActivityDetailPlanVo> findDetailByPlanCodeList(Collection<String> collect);

    void updateAccountAndName(String code, String createAccount, String createName);

    List<SubComActivityDetailPlanVo> findListByDetailCodes(Set<String> activityCodes);

    /**
     * 查询（费用预测用）
     * @param pageable
     * @param subCOmDetailPlanDto
     * @return
     */
    Page<String> findByDtoForPrediction(Pageable pageable, SubComActivityDetailPlanDto subCOmDetailPlanDto);

    BigDecimal findEstimatedWriteOffAmountByItemCode(String constituentDetailPlanItemCode);

    List<SubComActivityDetailPlanItemBudgetShareVo> findInOutSelfByItemCodes(List<String> itemCodes);
}
