package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service;

import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityProductStatisticalInfoVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 分子公司活动细案产品统计表(SubComActivityProductStatisticalInfo)表服务接口
 *
 * @author makejava
 * @date 2022-11-30 16:29:06
 */
public interface SubComActivityProductStatisticalInfoVoService {



    /**
     * 创建
     *
     * @param subComActivityProductStatisticalInfoVo
     * @return
     */
    SubComActivityProductStatisticalInfoVo create(SubComActivityProductStatisticalInfoVo subComActivityProductStatisticalInfoVo);


    /**
     * 按id集合启用
     *
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 按id集合禁用
     *
     * @param ids
     */
    void disableBatch(List<String> ids);

    /**
     * 逻辑删除
     *
     * @param ids
     */
    void updateDelFlagByIds(List<String> ids);

    /**
     * 根据分子公司细案编码获取统计数据
     * @param planCode 分子公司细案编码
     * @return
     */
    List<SubComActivityProductStatisticalInfoVo> findDetailByPlanCode(Pageable pageable, List<String> planCode);

    /**
     * 根据分子公司细案明细列表获取统计数据
     * @param planItemVos 分子公司细案明细列表
     * @param entity
     * @return
     */
    SubComActivityProductStatisticalInfoVo findDetailByItemVos(Pageable pageable, List<SubComActivityDetailPlanItemVo> planItemVos, SubComActivityDetailPlanDto dto);
}
