package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityProductStatisticalItemInfoDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityProductStatisticalItemInfoVo;
import org.springframework.data.domain.Pageable;

/**
 * 分子公司活动细案明细产品统计明细表(SubComActivityProductStatisticalItemInfo)表服务接口
 *
 * @author makejava
 * @date 2022-11-30 16:30:54
 */
public interface SubComActivityProductStatisticalItemInfoVoService {

    /**
     * 分页条件查询
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<SubComActivityProductStatisticalItemInfoVo> findByConditions(Pageable pageable, SubComActivityProductStatisticalItemInfoDto dto);

    /**
     * 按id查询详情
     *
     * @param id
     * @return
     */
    SubComActivityProductStatisticalItemInfoVo findDetailById(String id);

    /**
     * 创建
     *
     * @param subComActivityProductStatisticalItemInfoVo
     * @return
     */
    SubComActivityProductStatisticalItemInfoVo create(SubComActivityProductStatisticalItemInfoVo subComActivityProductStatisticalItemInfoVo);

    /**
     * 更新
     *
     * @param subComActivityProductStatisticalItemInfoVo
     * @return
     */
    SubComActivityProductStatisticalItemInfoVo update(SubComActivityProductStatisticalItemInfoVo subComActivityProductStatisticalItemInfoVo);

    /**
     * 按id集合启用
     *
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 按id集合禁用
     *
     * @param ids
     */
    void disableBatch(List<String> ids);

    /**
     * 逻辑删除
     *
     * @param ids
     */
    void updateDelFlagByIds(List<String> ids);
}
