package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.utils;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanStatusEnum;

import java.util.Date;

/**
 * 分子公司细案工具类
 */
public class SubComActivityUtils {


    /**
     * 获取分子公司细案活动状态
     * @param startTime 活动开始时间
     * @param endTime 活动结束时间
     * @return 活动状态枚举
     */
    public static ActivityPlanStatusEnum getActivityStatus(Date startTime, Date endTime){
        Date now  = new Date();
        if (startTime == null || endTime == null){
            return null;
        }
        //
        if (DateUtil.compare(endTime, now)>=0 && DateUtil.compare(startTime, now) <= 0){
            return ActivityPlanStatusEnum.executing;
        }
        if (DateUtil.compare(startTime, now)< 0){
            return ActivityPlanStatusEnum.unexecuted;
        }
        if (DateUtil.compare(endTime, now)> 0){
            return ActivityPlanStatusEnum.ended;
        }
        return null;
    }
}
