package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author : dengwei
 * @Date :2023/11/23  10:04
 * @Description: TODO
 */
@Data
public class ActivityDetailManageActivityTypeFeeVo {

    @ApiModelProperty(name = "orgCode",value = "组织编码",notes = "组织编码")
    private String orgCode;

    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "salesInstitutionName", value = "销售机构名称", notes = "销售机构名称")
    private String salesInstitutionName;

    /**
     * 费用所属年月
     */
    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;

    @ApiModelProperty("活动分类编码")
    private String activityTypeCode;

    @ApiModelProperty("活动分类名称")
    private String activityTypeName;

    @ApiModelProperty("费用合计")
    private BigDecimal totalCost;
}
