package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author : dengwei
 * @Date :2023/11/22  11:37
 * @Description: TODO
 */
@Data
public class ActivityDetailManageOneProductFeeVo {

    @ApiModelProperty(name = "orgCode",value = "组织编码",notes = "组织编码")
    private String orgCode;

    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "salesInstitutionName", value = "销售机构名称", notes = "销售机构名称")
    private String salesInstitutionName;

    /**
     * 费用所属年月
     */
    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;

    @ApiModelProperty("品牌名称")
    private String productBrandName;

    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    private String productCategoryName;

    @ApiModelProperty("品项名称")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称", notes = "产品编码")
    private String productName;

    @ApiModelProperty("费用合计")
    private BigDecimal totalCost;
}
