package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @Author : dengwei
 * @Date :2023/11/24  17:46
 * @Description: TODO
 */
@Data
public class AuditDetailSonCompanyBudgetWarnVo {

    @ApiModelProperty(name = "businessFormatCode", notes = "业态")
    private String businessFormatCode;

    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;

    @ApiModelProperty(name = "orgCode",value = "组织编码",notes = "组织编码")
    private String orgCode;


    @ApiModelProperty(name = "orgName",value = "组织名称",notes = "组织名称")
    private String orgName;

    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty("渠道编码")
    private String channelCode;

    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    private String activityFormCode;

    @ApiModelProperty("预算项目编码")
    private String budgetItemCode;
}
