package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName PrePaySubComActivityVo
 * @Description 活动预付获取分子公司细案Vo
 * @AUTHOR WangJJ
 * @DATE 2023/2/22 14:47
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动预付获取分子公司细案Vo")
public class PrePaySubComActivityVo {


    @ApiModelProperty("分子公司活动细案编码")
    private String constituentDetailPlanCode;

    @ApiModelProperty("分子公司活动细案名称")
    private String constituentDetailPlanName;

    @ApiModelProperty("分子公司活动细案明细编码")
    private String constituentDetailPlanItemCode;

    @ApiModelProperty("活动类型")
    private String activityType;

    @ApiModelProperty("活动形式编码")
    private String activityFormCode;

    @ApiModelProperty("活动形式")
    private String activityFormName;

    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityBeginTime;

    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityEndTime;

    @ApiModelProperty("品牌名称")
    private String productBrandName;

    @ApiModelProperty("品牌编码")
    private String productBrandCode;

    @ApiModelProperty("品类名称")
    private String productCategoryName;

    @ApiModelProperty("品类编码")
    private String productCategoryCode;

    @ApiModelProperty("品项名称")
    private String productItemName;

    @ApiModelProperty("品项编码")
    private String productItemCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("门店名称")
    private String terminalName;

    @ApiModelProperty("门店编码")
    private String terminalCode;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("销售组织名称")
    private String salesGroupName;

    @ApiModelProperty("零售商名称")
    private String resaleCommercialName;

    @ApiModelProperty("零售商编码")
    private String resaleCommercialCode;

    @ApiModelProperty("费用合计")
    private BigDecimal feeAmount;

    @ApiModelProperty("活动类型编号")
    private String activityTypeCode;

    @ApiModelProperty("活动类型名称")
    private String activityTypeName;

    @ApiModelProperty("销售组织编码")
    private String salesOrgCode;

    @ApiModelProperty("销售组织名称")
    private String salesInstitutionName;

    @ApiModelProperty("渠道编码")
    private String channelCode;




}
