package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 分子公司活动细案明细监控Vo
 *
 * @author chenlong
 * @date 2022-12-14 10:41:54
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "分子公司活动细案明细监控Vo")
public class SubComActivityDetailPlanMonitorVo extends TenantFlagOpVo {

    /**
     * 费用所属年月
     */
    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date feeYearMonth;

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    private String activityDetailCode;

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案名称")
    private String activityDetailName;
    /**
     * 活动细案明细编码
     */
    @ApiModelProperty("活动细案明细编码")
    private String activityDetailItemCode;
    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    private String activityTypeName;
    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    private String activityFormName;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty("销售机构名称")
    private String salesInstitutionName;

    /**
     * 销售部门编码
     */
    @ApiModelProperty("销售部门编码")
    private String salesDepartmentCode;

    /**
     * 销售部门名称
     */
    @ApiModelProperty("销售部门名称")
    private String salesDepartmentName;

    /**
     * 销售组编码
     */
    @ApiModelProperty("销售组编码")
    private String salesGroupCode;

    /**
     * 销售组名称
     */
    @ApiModelProperty("销售组名称")
    private String salesGroupName;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    private String channelCode;
    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    private String channelName;

    /**
     * 零售商编码
     */
    @ApiModelProperty("零售商编码")
    private String retailersCode;
    /**
     * 零售商名称
     */
    @ApiModelProperty("零售商名称")
    private String retailersName;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String customerCode;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String customerName;
    /**
     * 0
     * 门店编码
     */
    @ApiModelProperty("门店编码")
    private String terminalCode;
    /**
     * 门店名称
     */
    @ApiModelProperty("门店名称")
    private String terminalName;
    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String productItemName;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String productName;

    /**
     * 促销规则编码
     */
    @ApiModelProperty("促销规则编码")
    private String promotionRuleCode;
    /**
     * 促销规则名称
     */
    @ApiModelProperty("促销规则名称")
    private String promotionRuleName;
    /**
     * 核销方式
     */
    @ApiModelProperty("核销方式")
    private String auditType;
}

