package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 分子公司活动细案vo
 *
 * @author makejava
 * @date 2022-11-28 15:28:19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "分子公司活动细案Vo")
public class SubComActivityDetailPlanVo extends TenantFlagOpVo {


    @ApiModelProperty(name = "constituentDetailPlanCode", notes = "分子公司活动细案编码")
    private String constituentDetailPlanCode;

    @ApiModelProperty(name = "constituentDetailPlanName", notes = "分子公司活动细案名称")
    private String constituentDetailPlanName;

    @ApiModelProperty(name = "activityTemplateCode", notes = "活动模板编码，多个逗号隔开")
    private String activityTemplateCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "businessFormatCode", notes = "业态")
    private String businessFormatCode;


    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    private String salesInstitutionCode;


    @ApiModelProperty(name = "salesInstitutionName", value = "销售机构名称", notes = "销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty(name = "orgCode",value = "组织编码",notes = "组织编码")
    private String orgCode;


    @ApiModelProperty(name = "orgName",value = "组织名称",notes = "组织名称")
    private String orgName;

    @ApiModelProperty(name = "salesOrgCode",value = "销售部门编码",notes = "销售部门编码")
    private String salesOrgCode;


    @ApiModelProperty(name = "salesOrgName",value = "销售部门名称",notes = "销售部门名称")
    private String salesOrgName;


    @ApiModelProperty(name = "salesGroupCode",value = "销售组编码",notes = "销售组编码")
    private String salesGroupCode;


    @ApiModelProperty(name = "salesGroupName",value = "销售组名称",notes = "销售组名称")
    private String salesGroupName;

    /**
     * 费用所属年月
     */
    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;

    /**
     * 总申请金额
     */
    @ApiModelProperty(name = "totalApplyAmount",value = "总申请金额",notes = "总申请金额")
    private BigDecimal totalApplyAmount;


    @ApiModelProperty(name = "processStatus", notes = "审批状态", value = "审批状态")
    private String processStatus;


    @ApiModelProperty(name = "processKey", notes = "审批流程编码", value = "审批流程编码")
    private String processKey;


    @ApiModelProperty("活动状态")
    private String status;


    @ApiModelProperty("分子公司预算信息")
    private List<SubComActivityDetailPlanBudgetVo> budgetList;


    @ApiModelProperty("分子公司明细信息")
    private List<SubComActivityDetailPlanItemVo> itemList;

}

