package com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 分子公司活动细案明细产品统计明细表vo
 *
 * @author makejava
 * @date 2022-11-30 16:30:54
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "分子公司活动细案明细产品统计明细表Vo")
public class SubComActivityProductStatisticalItemInfoVo extends TenantFlagOpVo {

    @ApiModelProperty(name = "分子公司活动细案明细编码", notes = "分子公司活动细案明细编码")
    private String constituentDetailPlanItemCode;


    @ApiModelProperty(name = "分子公司活动细案明细名称", notes = "分子公司活动细案明细名称")
    private String constituentDetailPlanItemName;


    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;


    @ApiModelProperty(value = "预估销量", notes = "")
    private BigDecimal forecastSales;


    @ApiModelProperty(value = "预估成本", notes = "")
    private BigDecimal forecastCost;


    @ApiModelProperty(value = "预估销售额", notes = "")
    private BigDecimal forecastSalesVolume;


    @ApiModelProperty(value = "预估毛利", notes = "")
    private BigDecimal forecastGrossProfit;


    /**
     * 标准供货价
     */
    @ApiModelProperty(value = "标准供货价", notes = "")
    private BigDecimal standardSupplyPrice;

    /**
     * 促销费用 promotion
     */

    @ApiModelProperty(name = "promotionPrice", notes = "促销价")
    private BigDecimal promotionPrice;
}

