package com.biz.crm.tpm.business.subsidiary.activity.plan.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlanBudget;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanBudgetService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/6/27
 */
@RestController
@RequestMapping("/v1/subActivityPlanBudget/subActivityPlanBudget")
@Slf4j
@Api(tags = "分子活动方案-可用预算")
public class SubComActivityPlanBudgetController extends MnPageCacheController<SubComActivityPlanBudgetVo, SubComActivityPlanBudgetDto> {

    @Autowired(required = false)
    private SubComActivityPlanBudgetService subComActivityPlanBudgetService;



    /**
     * 创建审批-分页-更据流程编码查预算详情
     *
     * @param pageable
     * @param dto
     * @return
     */
    @ApiOperation(value = "创建审批-分页-更据流程编码查详情")
    @GetMapping(value = {"/findByProcessNoConditions/create"})
    public Result<Page<SubComActivityPlanBudgetVo>> findByProcessNoConditionsCreate(@PageableDefault(50) Pageable pageable,
                                                                                  SubComActivityPlanBudgetDto dto) {
        try {
            Page<SubComActivityPlanBudgetVo> result = this.subComActivityPlanBudgetService.findByProcessNoConditionsCreate(pageable, dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


}
