package com.biz.crm.tpm.business.subsidiary.activity.plan.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.constant.SubComActivityPlanConstant;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @Description:分子活动方案 --控制层
 * @Author qiancheng
 * @Date 2023/6/13
 */
@RestController
@RequestMapping("/v1/subActivityPlan/subActivityPlan")
@Slf4j
@Api(tags = "分子活动方案")
public class SubComActivityPlanController {

    @Autowired(required = false)
    private SubComActivityPlanService subComActivityPlanService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param dto
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<SubComActivityPlanVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                               SubComActivityPlanDto dto) {
        try {
            Page<SubComActivityPlanVo> result = this.subComActivityPlanService.findByConditions(pageable, dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增编辑
     *
     * @param cacheKey
     * @param dto
     * @return
     **/
    @ApiOperation(value = "新增编辑")
    @PostMapping(value = "create")
    public Result create(@ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey,
                                           @ApiParam(name = "dto", value = "分子活动方案表头") @RequestBody SubComActivityPlanDto dto) {
        try {
            this.subComActivityPlanService.create(dto, cacheKey);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping
    public Result<?> delete(@RequestParam("ids") List<String> ids) {
        try {
            this.subComActivityPlanService.delete(ids);
            return Result.ok("分子公司活动方案删除成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 提交流程,多选批量提交
     *
     * @param dto
     * @return
     */
    @ApiOperation(value = "提交流程,多选批量提交")
    @PostMapping(value = "submitApproval")
    public Result submitApproval(@ApiParam(value = "提交流程,多选批量提交")
                                 @RequestBody SubComActivityPlanApproveSubmitDto dto) {
        Assert.notNull(dto, "请选择数据！");
        List<String> idList = dto.getIds();
        Assert.notEmpty(idList, "请选择数据！");
        boolean lockSuccess = false;
        try {
            //提交审批前加锁一个小时
            lockSuccess = redisLockService.batchLock(SubComActivityPlanConstant.LOCK_SUB_COM_ACTIVITY_PLAN_APPROVE,
                    idList, TimeUnit.MINUTES, 10);
            Assert.isTrue(lockSuccess, "其他人正在操作数据,加锁失败,请稍后重试!");
            this.subComActivityPlanService.submitApproval(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        } finally {
            if (lockSuccess) {
                redisLockService.batchUnLock(SubComActivityPlanConstant.LOCK_SUB_COM_ACTIVITY_PLAN_APPROVE, idList);
            }
        }
    }


    @ApiOperation(value = "更据流程编码查详情")
    @GetMapping("/findByProcessNo")
    public Result<List<SubComActivityPlanVo>> findByProcessNo(@RequestParam("processNo") String processNo) {
        try {
            List<SubComActivityPlanVo> list = this.subComActivityPlanService.findByProcessNo(processNo);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "通过ids查详情（不包括预算）")
    @PostMapping("/findByIds")
    public Result<List<SubComActivityPlanVo>> findByIds(@RequestBody List<String> ids) {
        try {
            List<SubComActivityPlanVo> list = this.subComActivityPlanService.findByIds(ids);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "通过id查详情")
    @PostMapping("/findById")
    public Result<SubComActivityPlanVo> findByIds(@RequestParam("id") String id ) {
        try {
            SubComActivityPlanVo vo = this.subComActivityPlanService.findById(id);
            return Result.ok(vo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 查询分子预算预测信息
     *
     * @param pageable
     * @param dto
     * @return
     */
    @ApiOperation(value = "查询分子预算预测信息")
    @GetMapping(value = {"/findSubBudgetForecastByConditions"})
    public Result<Page<SubComActivityPlanBudgetVo>> findSubBudgetForecastByConditions(@PageableDefault(50) Pageable pageable,
                                                                                      SubComActivityPlanBudgetDto dto) {
        try {
            Page<SubComActivityPlanBudgetVo> result = this.subComActivityPlanService.findSubBudgetForecastByConditions(pageable, dto,null);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
