package com.biz.crm.tpm.business.subsidiary.activity.plan.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.constant.SubComActivityPlanConstant;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemFeeVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @Description:分子活动方案-方案内容 --控制层
 * @Author qiancheng
 * @Date 2023/6/13
 */
@RestController
@RequestMapping("/v1/subActivityPlanItem/subActivityPlanItem")
@Slf4j
@Api(tags = "分子活动方案-方案内容")
public class SubComActivityPlanItemController extends MnPageCacheController<SubComActivityPlanItemVo, SubComActivityPlanItemDto> {

    @Autowired(required = false)
    private SubComActivityPlanItemService subComActivityPlanItemService;

    @Autowired(required = false)
    private RedisLockService redisLockService;


    /**
     * 规划关联分子方案查询选框
     *
     * @param pageable
     * @param dto
     * @return
     */
    @ApiOperation(value = "规划关联分子方案查询选框")
    @GetMapping(value = {"/findPlanItemByConditions"})
    public Result<Page<SubComActivityPlanItemVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                               SubComActivityPlanItemDto dto) {
        try {
            Page<SubComActivityPlanItemVo> result = this.subComActivityPlanItemService.findPlanItemByConditions(pageable, dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 创建审批-分页-更据流程编码查详情
     *
     * @param pageable
     * @param dto
     * @return
     */
    @ApiOperation(value = "创建审批-分页-更据流程编码查详情")
    @GetMapping(value = {"/findByProcessNoConditions/create"})
    public Result<Page<SubComActivityPlanItemVo>> findByProcessNoConditionsCreate(@PageableDefault(50) Pageable pageable,
                                                                   SubComActivityPlanItemDto dto) {
        try {
            Page<SubComActivityPlanItemVo> result = this.subComActivityPlanItemService.findByProcessNoConditionsCreate(pageable, dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "查询可关闭的方案内容")
    @GetMapping(value = {"/closeFindDetail"})
    public Result<Page<SubComActivityPlanItemVo>> closeFindDetail(@PageableDefault(50) Pageable pageable,
                                                                  SubComActivityPlanItemDto dto) {
        try {
            Page<SubComActivityPlanItemVo> page = this.subComActivityPlanItemService.closeFindItem(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 关闭提交流程,多选批量提交
     *
     * @param dto
     * @return
     */
    @ApiOperation(value = "提交流程,多选批量提交")
    @PostMapping(value = "submitApproval")
    public Result closeSubmitApproval(@ApiParam(value = "提交流程,多选批量提交")
                                 @RequestBody SubComActivityPlanApproveSubmitDto dto) {
        Assert.notNull(dto, "请选择数据！");
        List<String> idList = dto.getIds();
        Assert.notEmpty(idList, "请选择数据！");
        boolean lockSuccess = false;
        try {
            //提交审批前加锁一个小时
            lockSuccess = redisLockService.batchLock(SubComActivityPlanConstant.LOCK_SUB_COM_ACTIVITY_PLAN_CLOSE_APPROVE,
                    idList, TimeUnit.MINUTES, 10);
            Assert.isTrue(lockSuccess, "其他人正在操作数据,加锁失败,请稍后重试!");
            this.subComActivityPlanItemService.closeSubmitApproval(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        } finally {
            if (lockSuccess) {
                redisLockService.batchUnLock(SubComActivityPlanConstant.LOCK_SUB_COM_ACTIVITY_PLAN_CLOSE_APPROVE, idList);
            }
        }
    }

    @ApiOperation(value = "更据流程编码查询方案内容详情")
    @GetMapping(value = {"/findByItemProcessNo"})
    public Result<Page<SubComActivityPlanItemVo>> findByItemProcessNo(@PageableDefault(50) Pageable pageable,
                                                                  String itemProcessNo) {
        try {
            Page<SubComActivityPlanItemVo> page = this.subComActivityPlanItemService.findByItemProcessNo(pageable, itemProcessNo);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "查询使用明细")
    @GetMapping(value = {"/findItemFeeByItemCode"})
    public Result<Page<SubComActivityPlanItemFeeVo>> findItemFeeByItemCode(@PageableDefault(50) Pageable pageable,
                                                                      String itemCode) {
        try {
            Page<SubComActivityPlanItemFeeVo> page = this.subComActivityPlanItemService.findItemFeeByItemCode(pageable, itemCode);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
