package com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @Description:分子活动方案
 * @Author qiancheng
 * @Date 2023/6/13
 */
@ApiModel(value = "SubComActivityPlan", description = "TPM-分子活动方案")
@TableName("tpm_sub_com_activity_plan")
@Getter
@Setter
@Entity(name = "tpm_sub_com_activity_plan")
@Table(name = "tpm_sub_com_activity_plan",
        indexes = {@Index(name = "tpm_sub_com_activity_plan_index1", columnList = "sub_activity_plan_code", unique = true),
                @Index(name = "tpm_sub_com_activity_plan_index2", columnList = "process_no")})
@org.hibernate.annotations.Table(appliesTo = "tpm_sub_com_activity_plan", comment = "TPM-分子活动方案")
public class SubComActivityPlan extends TenantFlagOpEntity {

    /**
     * 业态
     */
    @ApiModelProperty("业态")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 组织编码/归属部门/分子公司编码
     */
    @ApiModelProperty(name = "组织编码/归属部门", notes = "")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码/归属部门 '")
    private String orgCode;

    /**
     * 组织名称/归属部门/分子公司名称
     */
    @ApiModelProperty(name = "组织名称/归属部门", notes = "")
    @Column(name = "org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '组织名称/归属部门 '")
    private String orgName;

    /**
     * 方案编码
     */
    @ApiModelProperty("方案编码")
    @Column(name = "sub_activity_plan_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动规划编码 '")
    private String subActivityPlanCode;

    /**
     * 方案名称
     */
    @ApiModelProperty("方案名称")
    @Column(name = "sub_activity_plan_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动规划名称 '")
    private String subActivityPlanName;

    /**
     * 方案类型
     */
    @ApiModelProperty("方案类型")
    @Column(name = "sub_activity_plan_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '方案类型 '")
    private String subActivityPlanType;


    /**
     * 年月
     */
    @ApiModelProperty("年月")
    @Column(name = "fee_year_month", nullable = true, length = 20, columnDefinition = "VARCHAR(20) COMMENT '年月 '")
    private String feeYearMonth;

    /**
     * 方案金额
     */
    @ApiModelProperty(name = "方案金额")
    @Column(name = "apply_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '方案金额 '")
    private BigDecimal applyAmount;

    /**
     * 汇总销售额
     */
    @ApiModelProperty("汇总销售额")
    @Column(name = "sales_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '汇总销售额 '")
    private BigDecimal salesAmount;

    /**
     * 流程编码
     */
    @ApiModelProperty("流程编码")
    @Column(name = "process_no", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '流程编码 '")
    private String processNo;

    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    @Column(name = "process_status", nullable = true, length = 1, columnDefinition = "VARCHAR(1) COMMENT '审批状态 '")
    private String processStatus;
}
