package com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @Description:分子活动方案-预算信息
 * @Author qiancheng
 * @Date 2023/6/13
 */
@ApiModel(value = "SubComActivityPlanBudget", description = "TPM-分子活动方案预算信息")
@TableName("tpm_sub_com_activity_plan_budget")
@Getter
@Setter
@Entity(name = "tpm_sub_com_activity_plan_budget")
@Table(name = "tpm_sub_com_activity_plan_budget",
        indexes = {@Index(name = "tpm_sub_com_activity_plan_budget_index1", columnList = "sub_activity_plan_code"),
        })
@org.hibernate.annotations.Table(appliesTo = "tpm_sub_com_activity_plan_budget", comment = "TPM-分子活动方案预算信息")
public class SubComActivityPlanBudget extends TenantFlagOpEntity {

    @ApiModelProperty("方案编码")
    @Column(name = "sub_activity_plan_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '方案编码 '")
    private String subActivityPlanCode;

    @ApiModelProperty("预算项目编码")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目编码 '")
    private String budgetItemCode;

    @ApiModelProperty("预算项目名称")
    @Column(name = "budget_item_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '预算项目名称 '")
    private String budgetItemName;

    @ApiModelProperty(name = "分子公司预算预测编码")
    @Column(name = "budget_forecast_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '分子公司预算预测编码 '")
    private String budgetForecastCode;

    @ApiModelProperty("费用来源[数据字典:tpm_fee_source]")
    @Column(name = "fee_source_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用来源[数据字典:tpm_fee_source] '")
    private String feeSourceCode;

    @ApiModelProperty(name = "年月")
    @Column(name = "year_month_ly", nullable = true, length = 20, columnDefinition = "VARCHAR(20) COMMENT '年月 '")
    private String yearMonthLy;

    @ApiModelProperty("期初可用金额")
    @Column(name = "initial_amount",nullable = true, length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '期初金额'")
    private BigDecimal initialAmount;

    @ApiModelProperty("方案使用金额")
    @Column(name = "plan_use_amount",nullable = true, length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '方案使用金额'")
    private BigDecimal planUseAmount;

    @ApiModelProperty("分子活动规划使用金额（未关联方案）")
    @Column(name = "sub_design_use_amount",nullable = true, length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '方案使用金额'")
    private BigDecimal subDesignUseAmount;

    @ApiModelProperty("剩余可用金额")
    @Column(name = "remainder_amount",nullable = true, length = 20, columnDefinition = "DECIMAL(20,6) COMMENT ' 剩余可用金额 '")
    private BigDecimal remainderAmount;

}
