package com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description:分子活动方案-方案内容明细
 * @Author qiancheng
 * @Date 2023/6/13
 */
@ApiModel(value = "SubComActivityPlanItem", description = "TPM-分子活动方案内容明细")
@TableName("tpm_sub_com_activity_plan_item")
@Getter
@Setter
@Entity(name = "tpm_sub_com_activity_plan_item")
@Table(name = "tpm_sub_com_activity_plan_item",
        indexes = {
                @Index(name = "tpm_sub_com_activity_plan_item_index1", columnList = "sub_activity_plan_item_code", unique = true),
                @Index(name = "tpm_sub_com_activity_plan_item_index2", columnList = "sub_activity_plan_code", unique = false),
        })
@org.hibernate.annotations.Table(appliesTo = "tpm_sub_com_activity_plan_item", comment = "TPM-分子活动方案内容明细")
public class SubComActivityPlanItem extends TenantFlagOpEntity {

    @ApiModelProperty("方案编码")
    @Column(name = "sub_activity_plan_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '方案编码 '")
    private String subActivityPlanCode;

    @ApiModelProperty("方案名称")
    @Column(name = "sub_activity_plan_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '方案名称 '")
    private String subActivityPlanName;

    @ApiModelProperty("方案明细编码")
    @Column(name = "sub_activity_plan_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '方案明细编码 '")
    private String subActivityPlanItemCode;

    @ApiModelProperty("方案明细名称")
    @Column(name = "sub_activity_plan_item_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '方案明细名称 '")
    private String subActivityPlanItemName;

    @ApiModelProperty("方案状态")
    @Column(name = "activity_status", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '方案状态 '")
    private String activityStatus;

    @ApiModelProperty(name = "执行部门编码(头表组织的下级组织编码)", notes = "")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '部门编码(头表组织的下级组织编码)'")
    private String orgCode;

    @ApiModelProperty(name = "执行部门名称(头表组织的下级组织名称)", notes = "")
    @Column(name = "org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '部门名称(头表组织的下级组织名称)'")
    private String orgName;

    @ApiModelProperty("活动类型编码")
    @Column(name = "activity_type_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动类型编码'")
    private String activityTypeCode;

    @ApiModelProperty("活动类型名称")
    @Column(name = "activity_type_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动类型编码'")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    @Column(name = "activity_form_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty("活动力度说明")
    @Column(name = "activity_intensity", length = 255, columnDefinition = "varchar(255) COMMENT '活动力度说明'")
    private String activityIntensity;

    @ApiModelProperty("预算项目编码")
    @Column(name = "budget_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '预算项目编码'")
    private String budgetItemCode;

    @ApiModelProperty("预算项目名称")
    @Column(name = "budget_item_name", length = 255, columnDefinition = "varchar(255) COMMENT '预算项目编码'")
    private String budgetItemName;

    @ApiModelProperty(name = "费用来源")
    @Column(name = "fee_source_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用来源'")
    private String feeSourceCode;

    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    @Column(name = "activity_begin_time", length = 32, columnDefinition = "datetime COMMENT '活动开始时间'")
    private Date activityBeginTime;

    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    @Column(name = "activity_end_time", length = 32, columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date activityEndTime;

    @ApiModelProperty("费用金额")
    @Column(name = "total_cost", columnDefinition = "decimal(20,6) COMMENT '费用金额'")
    private BigDecimal totalCost;

    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 64, columnDefinition = "varchar(64) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 64, columnDefinition = "varchar(64) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty("品牌编码")
    @Column(name = "product_brand_code", length = 32, columnDefinition = "varchar(32) COMMENT '品牌编码'")
    private String productBrandCode;

    @ApiModelProperty("品牌名称")
    @TableField(value = "product_brand_name")
    @Column(name = "product_brand_name", length = 255, columnDefinition = "varchar(255) COMMENT '品牌名称'")
    private String productBrandName;

    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    @Column(name = "product_code", length = 64, columnDefinition = "varchar(64) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    @Column(name = "product_name", length = 255, columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty("预计销售额")
    @Column(name = "expect_sales_amount", columnDefinition = "decimal(20,6) COMMENT '预计销售额'")
    private BigDecimal expectSalesAmount;

    @ApiModelProperty("核销条件")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    @Column(name = "audit_condition", length = 32, columnDefinition = "varchar(32) COMMENT '核销条件编码'")
    private String auditCondition;

    @ApiModelProperty("核销条件编码")
    @Column(name = "audit_condition_code", length = 32, columnDefinition = "varchar(32) COMMENT '核销条件编码'")
    private String auditConditionCode;

    @ApiModelProperty("已使用金额")
    @Column(name = "used_amount", columnDefinition = "decimal(20,6) COMMENT '已使用金额'")
    private BigDecimal usedAmount;

    @ApiModelProperty("剩余可使用金额")
    @Column(name = "residue_amount", columnDefinition = "decimal(20,6) COMMENT '剩余可使用金额'")
    private BigDecimal residueAmount;

    @ApiModelProperty("流程编码")
    @Column(name = "item_process_no", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '流程编码 '")
    private String itemProcessNo;

    /**
     * 年月
     */
    @ApiModelProperty("年月")
    @Column(name = "fee_year_month", nullable = true, length = 20, columnDefinition = "VARCHAR(20) COMMENT '年月 '")
    private String feeYearMonth;

}
