package com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @Description:分子活动方案内容明细-使用明细
 * @Author qiancheng
 * @Date 2023/6/16
 */
@ApiModel(value = "SubComActivityPlanItemFee", description = "TPM-分子活动方案内容明细-使用明细")
@TableName("tpm_sub_com_activity_plan_item_fee")
@Getter
@Setter
@Entity(name = "tpm_sub_com_activity_plan_item_fee")
@Table(name = "tpm_sub_com_activity_plan_item_fee",
        indexes = {@Index(name = "tpm_item_fee_index1", columnList = "sub_activity_plan_item_code", unique = false),
                @Index(name = "tpm_item_fee_index2", columnList = "sort_asc", unique = false),
                @Index(name = "tpm_item_fee_index3", columnList = "sub_activity_plan_code", unique = false),
        })
@org.hibernate.annotations.Table(appliesTo = "tpm_sub_com_activity_plan_item_fee", comment = "TPM-分子活动方案内容明细-使用明细")
public class SubComActivityPlanItemFee extends TenantFlagOpEntity {

    @ApiModelProperty("方案编码")
    @Column(name = "sub_activity_plan_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '方案编码 '")
    private String subActivityPlanCode;

    @ApiModelProperty("方案名称")
    @Column(name = "sub_activity_plan_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '方案名称 '")
    private String subActivityPlanName;

    @ApiModelProperty("方案明细编码")
    @Column(name = "sub_activity_plan_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '方案明细编码 '")
    private String subActivityPlanItemCode;

    @ApiModelProperty("方案明细名称")
    @Column(name = "sub_activity_plan_item_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '方案明细名称 '")
    private String subActivityPlanItemName;

    @ApiModelProperty("业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    @ApiModelProperty("预算项目编码")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目编码 '")
    private String budgetItemCode;

    @ApiModelProperty("预算项目名称")
    @Column(name = "budget_item_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '预算项目名称 '")
    private String budgetItemName;

    @ApiModelProperty("期初金额")
    @Column(name = "initial_amount",nullable = true, length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '期初金额'")
    private BigDecimal initialAmount;

    @ApiModelProperty("操作前金额")
    @Column(name = "before_amount", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '操作前金额 '")
    private BigDecimal beforeAmount;

    @ApiModelProperty("当前操作金额")
    @Column(name = "cur_operation_amount", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '当前操作金额 '")
    private BigDecimal curOperationAmount;

    @ApiModelProperty("操作后余额")
    @Column(name = "balance_amount", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '操作后余额 '")
    private BigDecimal balanceAmount;

    @ApiModelProperty("业务编码/分子活动规划明细编码")
    @Column(name = "business_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务编码/分子活动规划明细编码 '")
    private String businessCode;

    @ApiModelProperty("分子活动规划编码")
    @Column(name = "activity_design_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '分子活动规划编码'")
    private String activityDesignCode;

    @ApiModelProperty("分子活动规划名称")
    @Column(name = "activity_design_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '分子活动规划名称'")
    private String activityDesignName;

    @ApiModelProperty("核销编码")
    @Column(name = "audit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销编码 '")
    private String auditCode;

    @ApiModelProperty("核销金额")
    @Column(name = "audit_amount", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '核销金额 '")
    private BigDecimal auditAmount;

    @ApiModelProperty("用于排序")
    @Column(name = "sort_asc", nullable = true, length = 20, columnDefinition = "BIGINT(20) COMMENT '用于排序 '")
    private Long sortAsc;

    /**
     * 操作类型[数据字典:tpm_forecast_operation_type]
     */
    @ApiModelProperty(value = "操作类型[数据字典:tpm_forecast_operation_type]", notes = "")
    @Column(name = "operation_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '操作类型[数据字典:tpm_forecast_operation_type] '")
    private String operationType;

}
