package com.biz.crm.tpm.business.subsidiary.activity.plan.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.exports.vo.SubComActivityPlanItemExportVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository.SubComActivityPlanItemRepository;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.enums.AuditConditionEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * @Description:分子公司方案明细导出
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Slf4j
@Component
public class SubComActivityPlanExportItemProcess implements ExportProcess<SubComActivityPlanItemExportVo> {

    @Autowired(required = false)
    private SubComActivityPlanItemRepository subComActivityPlanItemRepository;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    private static final String TPM_FEE_SOURCE = "tpm_fee_source";//费用来源


    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        Validate.notNull(params, "参数为空");
        //方案编码
        String subActivityPlanCode = (String) params.get("subActivityPlanCode");
        //方案名称
        String subActivityPlanName = (String) params.get("subActivityPlanName");
        //部门编码
        String orgCode = (String) params.get("orgCode");
        //部门名称
        String orgName = (String) params.get("orgName");
        //审批状态
        String processStatus = (String) params.get("processStatus");
        //方案类型
        String subActivityPlanType = (String) params.get("subActivityPlanType");
        //年月
        String feeYearMonth = (String) params.get("feeYearMonth");
        SubComActivityPlanDto selectDto = new SubComActivityPlanDto();
        selectDto.setSubActivityPlanCode(subActivityPlanCode);
        selectDto.setSubActivityPlanName(subActivityPlanName);
        selectDto.setOrgCode(orgCode);
        selectDto.setOrgName(orgName);
        selectDto.setProcessStatus(processStatus);
        selectDto.setSubActivityPlanType(subActivityPlanType);
        selectDto.setFeeYearMonth(feeYearMonth);
        selectDto.setTenantCode(TenantUtils.getTenantCode());
        return this.subComActivityPlanItemRepository.findExportTotal(selectDto);
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        //方案编码
        String subActivityPlanCode = (String) params.get("subActivityPlanCode");
        //方案名称
        String subActivityPlanName = (String) params.get("subActivityPlanName");
        //部门编码
        String orgCode = (String) params.get("orgCode");
        //部门名称
        String orgName = (String) params.get("orgName");
        //审批状态
        String processStatus = (String) params.get("processStatus");
        //方案类型
        String subActivityPlanType = (String) params.get("subActivityPlanType");
        //年月
        String feeYearMonth = (String) params.get("feeYearMonth");
        SubComActivityPlanDto selectDto = new SubComActivityPlanDto();
        selectDto.setSubActivityPlanCode(subActivityPlanCode);
        selectDto.setSubActivityPlanName(subActivityPlanName);
        selectDto.setOrgCode(orgCode);
        selectDto.setOrgName(orgName);
        selectDto.setProcessStatus(processStatus);
        selectDto.setSubActivityPlanType(subActivityPlanType);
        selectDto.setFeeYearMonth(feeYearMonth);
        selectDto.setTenantCode(TenantUtils.getTenantCode());
        Pageable pageable = PageRequest.of(vo.getPageNo()+1,this.getPageSize());
        Page<SubComActivityPlanItemExportVo> page = this.subComActivityPlanItemRepository.findExportPage(pageable,selectDto);
        if (page.getTotal() == 0) {
            return new JSONArray();
        }
        page.getRecords().forEach(exVo -> {
            if (!Objects.isNull(exVo.getActivityBeginTime())){
                exVo.setActivityBeginTimeStr(DateUtil.format(exVo.getActivityBeginTime(),DateUtil.DEFAULT_YEAR_MONTH_DAY));
            }
            if (!Objects.isNull(exVo.getActivityEndTime())){
                exVo.setActivityEndTimeStr(DateUtil.format(exVo.getActivityEndTime(),DateUtil.DEFAULT_YEAR_MONTH_DAY));
            }
            exVo.setAuditCondition(AuditConditionEnum.findByDes(exVo.getAuditCondition()));

            //转换相应的数据字典
            Map<String,
                    List<DictDataVo>> mapDict = dictDataVoService.findByDictTypeCodeList(
                    Lists.newArrayList(TPM_FEE_SOURCE));

            exVo.setFeeSourceCode(this.findDictValue(mapDict, TPM_FEE_SOURCE, exVo.getFeeSourceCode()));

        });
        return JSON.parseArray(JSON.toJSONString(page.getRecords()));
    }

    @Override
    public String getBusinessCode() {
        return "TPM_SUB_COM_ACTIVITY_PLAN_ITEM_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "分子公司方案明细导出";
    }

    /**
     * 获取字典值
     *
     * @param mapDict
     * @param dictTypeCode
     * @param code
     * @return
     */
    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (java.util.Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
            return StringUtils.EMPTY;
        }
        final List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return StringUtils.EMPTY;
        }
        final Optional<String> first =
                vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse(StringUtils.EMPTY);
    }

}
