package com.biz.crm.tpm.business.subsidiary.activity.plan.local.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description:分子公司方案明细导出vo
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Data
@ApiModel(value = "SubComActivityPlanExportVo", description = "分子公司方案明细导出vo")
@CrmExcelExport
public class SubComActivityPlanItemExportVo extends CrmExcelVo {

    @ApiModelProperty("方案编码")
    @CrmExcelColumn("方案编码")
    private String subActivityPlanCode;

    @ApiModelProperty("方案名称")
    @CrmExcelColumn("方案名称")
    private String subActivityPlanName;

    @ApiModelProperty(name = "分子公司编码")
    @CrmExcelColumn("分子公司编码")
    private String orgCode;

    @ApiModelProperty(name = "分子公司名称")
    @CrmExcelColumn("分子公司名称")
    private String orgName;

    @ApiModelProperty("年月")
    @CrmExcelColumn("年月")
    private String feeYearMonth;

    @ApiModelProperty("方案明细编码")
    @CrmExcelColumn("方案明细编码")
    private String subActivityPlanItemCode;

    @ApiModelProperty("方案明细名称")
    @CrmExcelColumn("方案明细名称")
    private String subActivityPlanItemName;

    @ApiModelProperty(name = "执行部门编码(头表组织的下级组织编码)")
    @CrmExcelColumn("执行部门编码")
    private String itemOrgCode;

    @ApiModelProperty(name = "执行部门名称(头表组织的下级组织名称)")
    @CrmExcelColumn("执行部门名称")
    private String itemOrgName;

    @ApiModelProperty(name = "活动形式编码")
    @CrmExcelColumn("活动形式编码")
    private String activityFormCode;

    @ApiModelProperty("活动形式名称")
    @CrmExcelColumn("活动形式名称")
    private String activityFormName;

    @ApiModelProperty("活动类型编码")
    @CrmExcelColumn("活动类型编码")
    private String activityTypeCode;

    @ApiModelProperty("活动类型名称")
    @CrmExcelColumn("活动类型名称")
    private String activityTypeName;

    @ApiModelProperty("活动力度说明")
    @CrmExcelColumn("活动力度说明")
    private String activityIntensity;

    @ApiModelProperty("预算项目编码")
    @CrmExcelColumn("预算项目编码")
    private String budgetItemCode;

    @ApiModelProperty("预算项目名称")
    @CrmExcelColumn("预算项目名称")
    private String budgetItemName;

    @ApiModelProperty(name = "费用来源")
    @CrmExcelColumn("费用来源")
    private String feeSourceCode;

    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginTime;
    @CrmExcelColumn("活动开始时间")
    private String activityBeginTimeStr;

    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndTime;
    @CrmExcelColumn("活动结束时间")
    private String activityEndTimeStr;

    @ApiModelProperty("费用金额")
    @CrmExcelColumn("费用金额")
    private BigDecimal totalCost;

    @ApiModelProperty("客户编码")
    @CrmExcelColumn("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @CrmExcelColumn("客户名称")
    private String customerName;

    @ApiModelProperty("品牌编码")
    @CrmExcelColumn("品牌编码")
    private String productBrandCode;

    @ApiModelProperty("品牌名称")
    @CrmExcelColumn("品牌名称")
    private String productBrandName;

    @ApiModelProperty("产品编码")
    @CrmExcelColumn("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    @CrmExcelColumn("产品名称")
    private String productName;

    @ApiModelProperty("预计销售额")
    @CrmExcelColumn("预计销售额")
    private BigDecimal expectSalesAmount;

    @ApiModelProperty("核销条件")
    @CrmExcelColumn("核销条件")
    private String auditCondition;

    @ApiModelProperty("核销条件编码")
    @CrmExcelColumn("核销条件编码")
    private String auditConditionCode;

}
