package com.biz.crm.tpm.business.subsidiary.activity.plan.local.imports.model;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description:分子公司方案导入vo
 * @Author qiancheng
 * @Date 2023/6/21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TPM-分子公司方案导入vo")
@CrmExcelImport(startRow = 2)
public class SubComActivityPlanImportVo extends CrmExcelVo {

    @CrmExcelColumn("方案名称")
    private String subActivityPlanName;

    @CrmExcelColumn("年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private String feeYearMonth;

    @CrmExcelColumn("分子公司编码")
    private String orgCode;

    @CrmExcelColumn("分子公司名称")
    private String orgName;

    @CrmExcelColumn("方案明细名称")
    private String subActivityPlanItemName;

    @CrmExcelColumn("执行部门编码(头表组织的下级组织编码)")
    private String itemOrgCode;

    @CrmExcelColumn("执行部门编码(头表组织的下级组织编码)")
    private String itemOrgName;

    @CrmExcelColumn("活动形式编码")
    private String activityFormCode;

    @CrmExcelColumn("活动形式名称")
    private String activityFormName;

    @CrmExcelColumn("活动类型编码")
    private String activityTypeCode;

    @CrmExcelColumn("活动类型名称")
    private String activityTypeName;

    @CrmExcelColumn("方案力度说明")
    private String activityIntensity;

    @CrmExcelColumn("预算项目编码")
    private String budgetItemCode;

    @CrmExcelColumn("预算项目名称")
    private String budgetItemName;

    @CrmExcelColumn("费用来源")
    private String feeSourceCode;

    @CrmExcelColumn("活动开始时间")
    private String activityBeginTimeStr;
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginTime;


    @CrmExcelColumn("活动结束时间")
    private String activityEndTimeStr;
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndTime;


    @CrmExcelColumn("费用金额")
    private String totalCostStr;
    private BigDecimal totalCost;

    @CrmExcelColumn("客户编码")
    private String customerCode;

    @CrmExcelColumn("客户名称")
    private String customerName;

    @CrmExcelColumn("品牌编码")
    private String productBrandCode;

    @CrmExcelColumn("品牌名称")
    private String productBrandName;

    @CrmExcelColumn("产品编码")
    private String productCode;

    @CrmExcelColumn("产品名称")
    private String productName;

    @CrmExcelColumn("预计销售额")
    private String expectSalesAmountStr;
    private BigDecimal expectSalesAmount;

    @CrmExcelColumn("核销条件")
    private String auditCondition;

    @CrmExcelColumn("核销条件编码")
    private String auditConditionCode;

}
