package com.biz.crm.tpm.business.subsidiary.activity.plan.local.imports.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.biz.crm.business.common.sdk.utils.DateTimeValidateUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.imports.model.SubComActivityPlanImportVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.enums.AuditConditionEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/6/21
 */
@Slf4j
@Component
public class SubComActivityPlanImportProcess implements ImportProcess<SubComActivityPlanImportVo> {

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;
    
    @Autowired(required = false)
    private ActivityFormService activityFormService;

    @Autowired(required = false)
    private SubComActivityPlanService subComActivityPlanService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    private static final String TPM_FEE_SOURCE = "tpm_fee_source";//费用来源


    @Override
    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Map<Integer, String> execute(LinkedHashMap<Integer, SubComActivityPlanImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        try {
            if (CollectionUtil.isEmpty(data)) {
                return null;
            }
            Collection<SubComActivityPlanImportVo> subComActivityPlanImportVos = data.values();
            subComActivityPlanImportVos.forEach( importVo -> {
                Validate.notBlank(importVo.getSubActivityPlanName(),"方案名称不能为空！");
                if (!StringUtils.isBlank(importVo.getFeeYearMonth())) {
                    try {
                        DateUtil.parse(importVo.getFeeYearMonth(),DateUtil.DEFAULT_YEAR_MONTH);
                    } catch (Exception e) {
                        throw new IllegalArgumentException("年月格式错误，正确格式为yyyy-MM");
                    }
                }
                if (!StringUtils.isBlank(importVo.getActivityBeginTimeStr())) {
                    if (DateTimeValidateUtil.validateDate(importVo.getActivityBeginTimeStr())) {
                        importVo.setActivityBeginTime(DateUtil.parse(importVo.getActivityBeginTimeStr(),DateUtil.DEFAULT_YEAR_MONTH_DAY));
                    }else {
                        throw new IllegalArgumentException("活动开始时间格式错误，正确格式为yyyy-MM-dd");

                    }
                }
                if (!StringUtils.isBlank(importVo.getActivityEndTimeStr())) {
                    if (DateTimeValidateUtil.validateDate(importVo.getActivityEndTimeStr())) {
                        importVo.setActivityEndTime(DateUtil.parse(importVo.getActivityEndTimeStr(),DateUtil.DEFAULT_YEAR_MONTH_DAY));
                    }else {
                        throw new IllegalArgumentException("活动结束时间格式错误，正确格式为yyyy-MM-dd");
                    }
                }

            });

            Map<String, List<SubComActivityPlanImportVo>> subComGroup =
                    subComActivityPlanImportVos.stream().collect(Collectors.groupingBy(SubComActivityPlanImportVo::getSubActivityPlanName));
            subComGroup.forEach((k, v) -> {
                List<String> orgCodes = v.stream().map(SubComActivityPlanImportVo::getOrgCode).distinct().collect(Collectors.toList());
                Validate.notEmpty(orgCodes,"分子公司编码不能为空！");
                Validate.isTrue(orgCodes.size() == 1,"同一方案，分子公司必须相同！");

                SubComActivityPlanDto planDto = new SubComActivityPlanDto();
                SubComActivityPlanImportVo importVo1 = v.get(0);
                String orgCode = v.get(0).getOrgCode();
                OrgVo orgVo = orgVoService.findByOrgCode(orgCode);
                Validate.notNull(orgVo, "组织不存在！！！");
                planDto.setOrgCode(orgVo.getOrgCode());
                planDto.setOrgName(orgVo.getOrgName());

                planDto.setSubActivityPlanName(importVo1.getSubActivityPlanName());
                planDto.setFeeYearMonth(importVo1.getFeeYearMonth());

                //产品
                List<String> productCodes = v.stream().map(SubComActivityPlanImportVo::getProductCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<ProductVo> productVoList = productVoService.findByCodes(productCodes);
                Map<String, ProductVo> productVoMap = Maps.newHashMap();
                if (!CollectionUtils.isEmpty(productVoList)){
                    productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
                }
                //组织
                List<OrgVo> orgVos = orgVoService.findAllChildrenByOrgCode(orgVo.getOrgCode());
                Map<String, OrgVo> orgVosMap = Maps.newHashMap();
                if (!CollectionUtils.isEmpty(orgVos)) {
                    orgVosMap = orgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity()));
                }
                List<String> activityFormCodes = v.stream().map(SubComActivityPlanImportVo::getActivityFormCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<ActivityFormVo> activityFormVos = activityFormService.findByCodes(activityFormCodes);
                Map<String, ActivityFormVo> activityFormMap = new HashMap<>();
                if (!CollectionUtils.isEmpty(activityFormVos)) {
                    activityFormMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode,Function.identity()));
                }

                List<SubComActivityPlanItemDto> planItemDtoList = new ArrayList<>(v.size());
                for (SubComActivityPlanImportVo importVo : v) {
                    SubComActivityPlanItemDto planItemDto = this.conversion(importVo,productVoMap,orgVosMap,activityFormMap);
                    planItemDtoList.add(planItemDto);
                }

                planDto.setItemList(planItemDtoList);
                this.subComActivityPlanService.create(planDto,null);
            });

        } catch (Exception e) {
            log.error("导入分子公司方案主表异常,{}",e);
            if (StrUtil.isEmpty(e.getMessage())){
                throw new IllegalArgumentException("空指针异常",e);
            }else {
                throw new IllegalArgumentException(e.getMessage(),e);
            }

        }
        return null;
    }

    private SubComActivityPlanItemDto conversion(SubComActivityPlanImportVo importVo,
                                                 Map<String, ProductVo> productVoMap,
                                                 Map<String, OrgVo> orgVosMap,
                                                 Map<String, ActivityFormVo> activityFormMap) {


        SubComActivityPlanItemDto planItem = nebulaToolkitService.copyObjectByWhiteList(importVo, SubComActivityPlanItemDto.class, HashSet.class, ArrayList.class);

        Validate.notBlank(importVo.getTotalCostStr(),"方案明细名称["+planItem.getSubActivityPlanItemName()+"]的 '费用金额',不能为空！");
        Validate.notBlank(importVo.getExpectSalesAmountStr(),"方案明细名称["+planItem.getSubActivityPlanItemName()+"]的 '预销售额',不能为空！");
        try {
            planItem.setTotalCost(new BigDecimal(importVo.getTotalCostStr()));
        } catch (Exception e) {
            throw new IllegalArgumentException("方案明细名称["+planItem.getSubActivityPlanItemName()+"]的 ’费用金额‘填写有误！");
        }
        try {
            planItem.setExpectSalesAmount(new BigDecimal(importVo.getExpectSalesAmountStr()));
        } catch (Exception e) {
            throw new IllegalArgumentException("方案明细名称["+planItem.getSubActivityPlanItemName()+"]的 ’预销售额‘填写有误！");

        }

        /*//执行部门
        planItem.setOrgCode(importVo.getItemOrgCode());
        planItem.setOrgName(importVo.getItemOrgName());*/
        // 执行部门
        if (!StringUtils.isBlank(planItem.getOrgCode())) {
            if (!CollectionUtils.isEmpty(orgVosMap)) {
                //头组织编码为key
                OrgVo orgVo = orgVosMap.get(importVo.getItemOrgCode());
                Validate.notNull(orgVo,"未查询到分子公司["+importVo.getOrgName()+importVo.getOrgCode()+"]的下级执行部门["+importVo.getItemOrgName()+importVo.getItemOrgCode()+"]!");
                planItem.setOrgCode(orgVo.getOrgCode());
                planItem.setOrgName(orgVo.getOrgName());
            }else {
                throw new IllegalArgumentException("未查询到执行部门信息！"+planItem.getOrgCode());
            }
        }

        //产品
        if (!StringUtils.isBlank(planItem.getProductCode())) {
            if (!CollectionUtils.isEmpty(productVoMap)) {
                ProductVo productVo = productVoMap.get(planItem.getProductCode());
                Validate.notNull(productVo,"未查询到产品信息！"+planItem.getProductCode());
                planItem.setProductCode(productVo.getProductCode());
                planItem.setProductName(productVo.getProductName());
                planItem.setProductBrandCode(productVo.getProductBrandCode());
                planItem.setProductBrandName(productVo.getProductBrandName());
            }else {
                throw new IllegalArgumentException("未查询到产品信息！"+planItem.getProductCode());
            }
        }
        //活动形式、活动分类
        if (!StringUtils.isBlank(planItem.getActivityFormCode())) {
            if (!CollectionUtils.isEmpty(activityFormMap)) {
                ActivityFormVo activityFormVo = activityFormMap.get(planItem.getActivityFormCode());
                Validate.notNull(activityFormVo,"未查询到活动形式信息！"+planItem.getActivityFormCode());
                planItem.setActivityFormCode(activityFormVo.getActivityFormCode());
                planItem.setActivityFormName(activityFormVo.getActivityFormName());
            }else {
                throw new IllegalArgumentException("未查询到活动形式信息！"+planItem.getActivityFormCode());
            }
        }
        planItem.setAuditCondition(AuditConditionEnum.findByDes(importVo.getAuditCondition()));
        //转换相应的数据字典
        Map<String,
                List<DictDataVo>> mapDict = dictDataVoService.findByDictTypeCodeList(
                Lists.newArrayList(TPM_FEE_SOURCE));

        planItem.setFeeSourceCode(this.findDictValue(mapDict, TPM_FEE_SOURCE, planItem.getFeeSourceCode()));

        return planItem;
    }

    @Override
    public Class<SubComActivityPlanImportVo> findCrmExcelVoClass() {
        return SubComActivityPlanImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_SUB_COM_ACTIVITY_PLAN_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "TPM-分子公司方案导入";
    }

    /**
     * 获取字典值
     *
     * @param mapDict
     * @param dictTypeCode
     * @param code
     * @return
     */
    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (java.util.Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
            return StringUtils.EMPTY;
        }
        final List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return StringUtils.EMPTY;
        }
        final Optional<String> first =
                vos.stream().filter(a -> a.getDictValue().equals(code)).map(DictDataVo::getDictCode).findFirst();
        return first.orElse(StringUtils.EMPTY);
    }
}
