package com.biz.crm.tpm.business.subsidiary.activity.plan.local.imports.service;

import cn.hutool.core.util.StrUtil;
import com.biz.crm.business.common.sdk.utils.DateTimeValidateUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.imports.model.SubComActivityPlanImportVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.imports.model.SubComActivityPlanItemImportVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.service.internal.SubComActivityPlanItemPageCacheHelper;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.enums.AuditConditionEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/6/25
 */
@Slf4j
@Component
public class SubComActivityPlanItemImportProcess implements ImportProcess<SubComActivityPlanItemImportVo> {

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Autowired(required = false)
    private ActivityFormService activityFormService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private SubComActivityPlanItemPageCacheHelper subComActivityPlanItemPageCacheHelper;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    private static final String TPM_FEE_SOURCE = "tpm_fee_source";//费用来源


    @Override
    public Integer getBatchCount() {
        return 2000;
    }

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, SubComActivityPlanItemImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        try {
            log.info("TPM-分子活动规划明细导入-买赠，执行");
            Object cacheKey = params.get("cacheKey");
            Validate.notNull(cacheKey,"缓存key不能为null");

            Collection<SubComActivityPlanItemImportVo> values = data.values();
            if (CollectionUtils.isNotEmpty(values)) {

                //产品
                List<String> productCodes = values.stream().map(SubComActivityPlanItemImportVo::getProductCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<ProductVo> productVoList = productVoService.findByCodes(productCodes);
                Map<String, ProductVo> productVoMap = Maps.newHashMap();
                if (CollectionUtils.isNotEmpty(productVoList)){
                    productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
                }
                //组织
                List<String> itemOrgVoCodes = values.stream().map(SubComActivityPlanItemImportVo::getOrgCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<OrgVo> orgVos = orgVoService.findByOrgCodes(itemOrgVoCodes);
                Map<String, OrgVo> orgVosMap = Maps.newHashMap();
                if (CollectionUtils.isNotEmpty(orgVos)) {
                    //List<String> orgCodes = orgVos.stream().map(OrgVo::getOrgCode).distinct().collect(Collectors.toList());
                    //Validate.isTrue( CollectionUtils.isNotEmpty(orgCodes) && orgVos.size() == 1,"执行部门需在同一个上级组织下");
                    orgVosMap = orgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode,Function.identity(),(v1,v2) -> v2));
                }
                List<String> activityFormCodes = values.stream().map(SubComActivityPlanItemImportVo::getActivityFormCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<ActivityFormVo> activityFormVos = activityFormService.findByCodes(activityFormCodes);
                Map<String, ActivityFormVo> activityFormMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(activityFormVos)) {
                    activityFormMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode,Function.identity()));
                }

                List<SubComActivityPlanItemDto> itemDtoList = new ArrayList<>(values.size());
                for (SubComActivityPlanItemImportVo importVo : values) {

                    SubComActivityPlanItemDto itemDto = this.conversion(importVo,productVoMap,orgVosMap,activityFormMap);
                    if (!Objects.isNull(itemDto)) {
                        itemDtoList.add(itemDto);
                    }
                }
                subComActivityPlanItemPageCacheHelper.importNewItem(cacheKey.toString(),itemDtoList);
            }
        } catch (Exception e) {
            log.error("导入分子公司方案明细异常,{}",e);
            if (StrUtil.isEmpty(e.getMessage())){
                throw new IllegalArgumentException("空指针异常",e);
            }else {
                throw new IllegalArgumentException(e.getMessage(),e);
            }
        }
        return null;
    }

    private SubComActivityPlanItemDto conversion(SubComActivityPlanItemImportVo importVo,
                                                 Map<String, ProductVo> productVoMap,
                                                 Map<String, OrgVo> orgVosMap,
                                                 Map<String, ActivityFormVo> activityFormMap) {

        if (Objects.isNull(importVo)) {
            return null;
        }
        if (!StringUtils.isBlank(importVo.getActivityBeginTimeStr())) {
            if (DateTimeValidateUtil.validateDate(importVo.getActivityBeginTimeStr())) {
                importVo.setActivityBeginTime(DateUtil.parse(importVo.getActivityBeginTimeStr(),DateUtil.DEFAULT_YEAR_MONTH_DAY));
            }else {
                throw new IllegalArgumentException("活动开始时间格式错误，正确格式为yyyy-MM-dd");

            }
        }
        if (!StringUtils.isBlank(importVo.getActivityEndTimeStr())) {
            if (DateTimeValidateUtil.validateDate(importVo.getActivityEndTimeStr())) {
                importVo.setActivityEndTime(DateUtil.parse(importVo.getActivityEndTimeStr(),DateUtil.DEFAULT_YEAR_MONTH_DAY));
            }else {
                throw new IllegalArgumentException("活动结束时间格式错误，正确格式为yyyy-MM-dd");
            }
        }

        SubComActivityPlanItemDto itemDto = nebulaToolkitService.copyObjectByWhiteList(importVo, SubComActivityPlanItemDto.class, HashSet.class, ArrayList.class);
        try {
            itemDto.setTotalCost(StringUtils.isBlank(importVo.getTotalCostStr()) ? BigDecimal.ZERO : new BigDecimal(importVo.getTotalCostStr()));
            itemDto.setExpectSalesAmount(StringUtils.isBlank(importVo.getExpectSalesAmountStr()) ? BigDecimal.ZERO : new BigDecimal(importVo.getExpectSalesAmountStr()));
        } catch (Exception e) {
            throw new IllegalArgumentException("方案明细名称["+itemDto.getSubActivityPlanItemName()+"]的 ’费用金额‘或’预销售额‘填写有误！");
        }
        // 执行部门
        if (!StringUtils.isBlank(itemDto.getOrgCode())) {
            if (!org.springframework.util.CollectionUtils.isEmpty(orgVosMap)) {
                OrgVo orgVo = orgVosMap.get(importVo.getOrgCode());
                Validate.notNull(orgVo,"未查询到方案明细名称["+itemDto.getSubActivityPlanItemName()+"]的执行部门["+itemDto.getOrgName()+itemDto.getOrgCode()+"]!");
                itemDto.setOrgCode(orgVo.getOrgCode());
                itemDto.setOrgName(orgVo.getOrgName());
            }else {
                throw new IllegalArgumentException("未查询到执行部门信息！"+itemDto.getOrgCode());
            }
        }
        //产品
        if (!StringUtils.isBlank(itemDto.getProductCode())) {
            if (!org.springframework.util.CollectionUtils.isEmpty(productVoMap)) {
                ProductVo productVo = productVoMap.get(itemDto.getProductCode());
                Validate.notNull(productVo,"未查询到产品信息！"+itemDto.getProductCode());
                itemDto.setProductCode(productVo.getProductCode());
                itemDto.setProductName(productVo.getProductName());
                itemDto.setProductBrandCode(productVo.getProductBrandCode());
                itemDto.setProductBrandName(productVo.getProductBrandName());
            }else {
                throw new IllegalArgumentException("未查询到产品信息！"+itemDto.getProductCode());
            }
        }
        //活动形式、活动分类
        if (!StringUtils.isBlank(itemDto.getActivityFormCode())) {
            if (!org.springframework.util.CollectionUtils.isEmpty(activityFormMap)) {
                ActivityFormVo activityFormVo = activityFormMap.get(itemDto.getActivityFormCode());
                Validate.notNull(activityFormVo,"未查询到活动形式信息！"+itemDto.getActivityFormCode());
                itemDto.setActivityFormCode(activityFormVo.getActivityFormCode());
                itemDto.setActivityFormName(activityFormVo.getActivityFormName());
                itemDto.setActivityTypeCode(activityFormVo.getActivityTypeCode());
                itemDto.setActivityTypeName(activityFormVo.getActivityTypeName());
            }else {
                throw new IllegalArgumentException("未查询到活动形式信息！"+itemDto.getActivityFormCode());
            }
        }
        //转换相应的数据字典
        Map<String,
                List<DictDataVo>> mapDict = dictDataVoService.findByDictTypeCodeList(
                Lists.newArrayList(TPM_FEE_SOURCE));

        itemDto.setFeeSourceCode(this.findDictValue(mapDict, TPM_FEE_SOURCE, itemDto.getFeeSourceCode()));


        itemDto.setAuditCondition(AuditConditionEnum.findByDes(importVo.getAuditCondition()));

        return itemDto;

    }

    @Override
    public Class<SubComActivityPlanItemImportVo> findCrmExcelVoClass() {
        return SubComActivityPlanItemImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_SUB_COM_ACTIVITY_PLAN_ITEM_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "TPM-分子公司方案明细导入";
    }

    /**
     * 获取字典值
     *
     * @param mapDict
     * @param dictTypeCode
     * @param code
     * @return
     */
    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (java.util.Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
            return StringUtils.EMPTY;
        }
        final List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return StringUtils.EMPTY;
        }
        final Optional<String> first =
                vos.stream().filter(a -> a.getDictValue().equals(code)).map(DictDataVo::getDictCode).findFirst();
        return first.orElse(StringUtils.EMPTY);
    }
}
