package com.biz.crm.tpm.business.subsidiary.activity.plan.local.listener;

import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.constant.SubComActivityPlanConstant;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.enums.SubPlanStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Description:分子公司活动方案关闭审批通过
 * @Author qiancheng
 * @Date 2023/6/25
 */
@Slf4j
@Component
public class SubActivityPlanCloseCompleteListener implements ProcessCompleteListener {

    @Autowired(required = false)
    private SubComActivityPlanItemService subComActivityPlanItemService;

    @Override
    public String getBusinessCode() {
        return SubComActivityPlanConstant.CLOSE_PROCESS_CODE;
    }

    @Override
    public void onProcessComplete(ProcessStatusDto dto) {
        Validate.notEmpty(dto.getProcessNo(), "流程编码不能为空！");
        String processStatus = dto.getProcessStatus();

        //审批通过
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            subComActivityPlanItemService.closePassProcessBusiness(dto.getProcessNo(),SubPlanStatusEnum.CLOSE.getCode());

        }
        //审批驳回|流程追回
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) ||
                ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            subComActivityPlanItemService.closeFailProcessBusiness(dto.getProcessNo(), SubPlanStatusEnum.CLOSE_REJECT.getCode());
        }
    }
}
