package com.biz.crm.tpm.business.subsidiary.activity.plan.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlanItem;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.exports.vo.SubComActivityPlanItemExportVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description:分子活动方案-方案内容明细 --数据库访问层
 * @Author qiancheng
 * @Date 2023/6/13
 */
public interface SubComActivityPlanItemMapper extends BaseMapper<SubComActivityPlanItem> {

    /**
     * 查询可关闭的方案内容详情
     *
     * @param page
     * @param dto
     * @return
     */
    Page<SubComActivityPlanItemVo> closeFindItem(Page<SubComActivityPlanVo> page,@Param("dto") SubComActivityPlanItemDto dto);

    /**
     * 更据流程编码查询方案内容详情
     *
     * @param page
     * @param itemProcessNo
     * @param tenantCode
     * @return
     */
    Page<SubComActivityPlanItemVo> findByItemProcessNo(Page<SubComActivityPlanVo> page,@Param("itemProcessNo") String itemProcessNo,@Param("tenantCode") String tenantCode);

    Integer findExportTotal(@Param("dto") SubComActivityPlanDto dto);

    Page<SubComActivityPlanItemExportVo> findExportPage(Page<SubComActivityPlanVo> page, @Param("dto") SubComActivityPlanDto dto);

    void autoUpdateStatus(@Param("processStatus")String processStatus,@Param("status") String status, @Param("tenantCode") String tenantCode);

    Page<SubComActivityPlanItemVo> findPlanItemByConditions(Page<SubComActivityPlanVo> page, @Param("dto") SubComActivityPlanItemDto dto);

    void updateReturnAmount(@Param("list") List<SubComActivityPlanItemDto> updateSubPlanItemList,@Param("tenantCode") String tenantCode);

    Page<SubComActivityPlanItemVo> findByProcessNoConditionsCreate(Page<SubComActivityPlanVo> page,@Param("dto") SubComActivityPlanItemDto dto);
}
