package com.biz.crm.tpm.business.subsidiary.activity.plan.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlan;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description:分子活动方案--数据库访问层
 * @Author qiancheng
 * @Date 2023/6/13
 */
public interface SubComActivityPlanMapper extends BaseMapper<SubComActivityPlan> {

    /**
     * 查询分页列表
     *
     * @param page
     * @param dto
     * @return
     */
    Page<SubComActivityPlanVo> findByConditions(Page<SubComActivityPlanVo> page,@Param("dto") SubComActivityPlanDto dto);

    /**
     * 更据流程编码查询方案
     *
     * @param processNo
     * @param tenantCode
     * @return
     */
    List<SubComActivityPlanVo> findByProcessNo(@Param("processNo") String processNo,@Param("tenantCode") String tenantCode);

    List<String> findPlanCodeByProcessNo(@Param("processNo") String processNo,@Param("tenantCode") String tenantCode);

}
