package com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlanBudget;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.mapper.SubComActivityPlanBudgetMapper;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Description:分子活动方案-预算信息 --数据库访问层
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Component
public class SubComActivityPlanBudgetRepository extends ServiceImpl<SubComActivityPlanBudgetMapper, SubComActivityPlanBudget> {


    public void deleteBySubPlanCodes(List<String> subPlanCodes) {
        this.lambdaUpdate()
                .set(SubComActivityPlanBudget::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .eq(SubComActivityPlanBudget::getTenantCode, TenantUtils.getTenantCode())
                .in(SubComActivityPlanBudget::getSubActivityPlanCode,subPlanCodes)
                .update();
    }

    public List<SubComActivityPlanBudget> findBySubPlanCode(String subPlanCode) {
        return this.lambdaQuery()
                .eq(SubComActivityPlanBudget::getSubActivityPlanCode,subPlanCode)
                .eq(SubComActivityPlanBudget::getTenantCode,TenantUtils.getTenantCode())
                .eq(SubComActivityPlanBudget::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    public Page<SubComActivityPlanBudgetVo> findByProcessNoConditionsCreate(Page<SubComActivityPlanVo> page, SubComActivityPlanBudgetDto dto) {
        return this.baseMapper.findByProcessNoConditionsCreate(page,dto);
    }
}
