package com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.ForecastOperationTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlanItemFee;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.mapper.SubComActivityPlanItemFeeMapper;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemFeeVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Description:分子活动方案内容明细-使用明细 --数据库访问层
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Component
public class SubComActivityPlanItemFeeRepository extends ServiceImpl<SubComActivityPlanItemFeeMapper, SubComActivityPlanItemFee> {


    public void deleteByItemCodes(List<String> itemCodes) {
        this.lambdaUpdate()
                .set(SubComActivityPlanItemFee::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .in(SubComActivityPlanItemFee::getSubActivityPlanItemCode,itemCodes)
                .eq(SubComActivityPlanItemFee::getTenantCode, TenantUtils.getTenantCode())
                .update();
    }

    public Page<SubComActivityPlanItemFeeVo> findItemFeeByItemCode(Page<SubComActivityPlanItemFeeVo> page, String itemCode) {
        return this.baseMapper.findItemFeeByItemCode(page,itemCode,TenantUtils.getTenantCode());
    }

    public List<SubComActivityPlanItemFee> findByActivityDesignCode(String activityDesignCode) {
        return lambdaQuery()
                .eq(SubComActivityPlanItemFee::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(SubComActivityPlanItemFee::getTenantCode,TenantUtils.getTenantCode())
                .eq(SubComActivityPlanItemFee::getActivityDesignCode,activityDesignCode)
                .orderByDesc(SubComActivityPlanItemFee::getSortAsc)
                .list();
    }

    public SubComActivityPlanItemFeeVo findLastByItemCode(String itemCode) {
        return this.baseMapper.findLastByItemCode(itemCode,TenantUtils.getTenantCode());
    }
}
