package com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlanItem;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.exports.vo.SubComActivityPlanItemExportVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.mapper.SubComActivityPlanItemMapper;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.enums.SubPlanStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @Description:分子活动方案-方案内容明细 --数据库访问层
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Component
public class SubComActivityPlanItemRepository extends ServiceImpl<SubComActivityPlanItemMapper, SubComActivityPlanItem> {


    public List<SubComActivityPlanItem> findBySubPlanCode(String subActivityPlanCode) {
        return this.lambdaQuery()
                .eq(SubComActivityPlanItem::getSubActivityPlanCode,subActivityPlanCode)
                .eq(SubComActivityPlanItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(SubComActivityPlanItem::getTenantCode, TenantUtils.getTenantCode())
                .list();

    }

    public List<SubComActivityPlanItem> findBySubPlanCodes(List<String> subPlanCodes) {
        return this.lambdaQuery()
                .in(SubComActivityPlanItem::getSubActivityPlanCode,subPlanCodes)
                .eq(SubComActivityPlanItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(SubComActivityPlanItem::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    public void deleteByIds(List<String> ids) {
        this.lambdaUpdate()
                .set(SubComActivityPlanItem::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .in(SubComActivityPlanItem::getId,ids)
                .update();
    }


    public Page<SubComActivityPlanItemVo> closeFindItem(Page<SubComActivityPlanVo> page, SubComActivityPlanItemDto dto) {
        return this.baseMapper.closeFindItem(page,dto);
    }

    public Page<SubComActivityPlanItemVo> findByItemProcessNo(Page<SubComActivityPlanVo> page, String itemProcessNo) {
        return this.baseMapper.findByItemProcessNo(page,itemProcessNo,TenantUtils.getTenantCode());
    }

    public Integer findExportTotal(SubComActivityPlanDto dto) {
        if (Objects.isNull(dto)) {
            return 0;
        }
        return this.baseMapper.findExportTotal(dto);
    }

    public Page<SubComActivityPlanItemExportVo> findExportPage(Pageable pageable, SubComActivityPlanDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new SubComActivityPlanDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<SubComActivityPlanVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.baseMapper.findExportPage(page,dto);
    }

    public List<SubComActivityPlanItem> findByItemCodes(List<String> itemCodes) {
        return lambdaQuery()
                .in(SubComActivityPlanItem::getSubActivityPlanItemCode,itemCodes)
                .eq(SubComActivityPlanItem::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(SubComActivityPlanItem::getTenantCode,TenantUtils.getTenantCode())
                .list();
    }

    public void updateActivityStatusByPlanCodes(List<String> planCodes, String status) {
        this.lambdaUpdate()
                .set(SubComActivityPlanItem::getActivityStatus,status)
                .eq(SubComActivityPlanItem::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(SubComActivityPlanItem::getTenantCode,TenantUtils.getTenantCode())
                .in(SubComActivityPlanItem::getSubActivityPlanCode,planCodes)
                .update();

    }

    public void updateActivityStatusByProcessNo(String processNo, String status) {
        this.lambdaUpdate()
                .set(SubComActivityPlanItem::getActivityStatus,status)
                .eq(SubComActivityPlanItem::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(SubComActivityPlanItem::getTenantCode,TenantUtils.getTenantCode())
                .eq(SubComActivityPlanItem::getItemProcessNo,processNo)
                .update();
    }

    public void autoUpdateStatus() {
        this.baseMapper.autoUpdateStatus(ProcessStatusEnum.PASS.getDictCode(),SubPlanStatusEnum.END.getCode(),TenantUtils.getTenantCode());
    }

    public Page<SubComActivityPlanItemVo> findPlanItemByConditions(Page<SubComActivityPlanVo> page, SubComActivityPlanItemDto dto) {
        return this.baseMapper.findPlanItemByConditions(page,dto);
    }

    public void updateReturnAmount(List<SubComActivityPlanItemDto> updateSubPlanItemList) {
        this.baseMapper.updateReturnAmount(updateSubPlanItemList,TenantUtils.getTenantCode());
    }

    public Page<SubComActivityPlanItemVo> findByProcessNoConditionsCreate(Page<SubComActivityPlanVo> page, SubComActivityPlanItemDto dto) {
        return this.baseMapper.findByProcessNoConditionsCreate(page,dto);
    }
}
