package com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlan;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.mapper.SubComActivityPlanMapper;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Description:分子活动方案--数据库访问层
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Component
public class SubComActivityPlanRepository extends ServiceImpl<SubComActivityPlanMapper, SubComActivityPlan> {

    public Page<SubComActivityPlanVo> findByConditions(Page<SubComActivityPlanVo> page, SubComActivityPlanDto dto) {
        return this.baseMapper.findByConditions(page,dto);
    }

    public List<SubComActivityPlan> listByIds(List<String> ids, String delFlag) {
        return this.lambdaQuery()
                .in(SubComActivityPlan::getId,ids)
                .eq(SubComActivityPlan::getDelFlag,delFlag)
                .eq(SubComActivityPlan::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    public void updateProcessStatusAndProcessNo(List<String> ids, String processStatus, String processNo) {
        this.lambdaUpdate()
                .set(SubComActivityPlan::getProcessStatus,processStatus)
                .set(SubComActivityPlan::getProcessNo,processNo)
                .in(SubComActivityPlan::getId,ids)
                .eq(SubComActivityPlan::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .update();

    }

    public void updateProcessStatusByProcessNo(String processNo, String processStatus) {
        this.lambdaUpdate()
                .set(SubComActivityPlan::getProcessStatus,processStatus)
                .eq(SubComActivityPlan::getProcessNo,processNo)
                .eq(SubComActivityPlan::getTenantCode,TenantUtils.getTenantCode())
                .update();
    }

    public List<SubComActivityPlanVo> findByProcessNo(String processNo) {
        return this.baseMapper.findByProcessNo(processNo,TenantUtils.getTenantCode());
    }

    public List<String> findPlanCodeByProcessNo(String processNo) {
        if (StringUtils.isBlank(processNo)) {
         return Lists.newArrayList();
        }
        return this.baseMapper.findPlanCodeByProcessNo(processNo,TenantUtils.getTenantCode());
    }
}
