package com.biz.crm.tpm.business.subsidiary.activity.plan.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.constant.SubComActivityPlanConstant;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanBudgetService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @Description:分子公司方案预算信息分页缓存服务助手
 * @Author qiancheng
 * @Date 2023/6/19
 */
@Component
public class SubComActivityPlanBudgetPageCacheHelper extends MnPageCacheHelper<SubComActivityPlanBudgetVo, SubComActivityPlanBudgetDto> {

    @Autowired(required = false)
    private SubComActivityPlanBudgetService subComActivityPlanBudgetService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public String getCacheKeyPrefix() {
        return SubComActivityPlanConstant.SUB_COM_ACTIVITY_PLAN_BUDGET_CACHE_KEY_PREFIX;
    }

    @Override
    public Class<SubComActivityPlanBudgetDto> getDtoClass() {
        return SubComActivityPlanBudgetDto.class;
    }

    @Override
    public Class<SubComActivityPlanBudgetVo> getVoClass() {
        return SubComActivityPlanBudgetVo.class;
    }

    @Override
    public List<SubComActivityPlanBudgetDto> findDtoListFromRepository(SubComActivityPlanBudgetDto dto, String cacheKey) {
        if (StringUtils.isEmpty(dto.getSubActivityPlanCode())){
            return Lists.newArrayList();
        }

        //从数据库里面查出来放到缓存里面
        List<SubComActivityPlanBudgetVo> budgetVoList = subComActivityPlanBudgetService.findBySubPlanCode(dto.getSubActivityPlanCode());
        List<SubComActivityPlanBudgetDto> budgetDtoList = (List<SubComActivityPlanBudgetDto>) nebulaToolkitService.copyCollectionByBlankList(budgetVoList, SubComActivityPlanBudgetVo.class, SubComActivityPlanBudgetDto.class, HashSet.class, ArrayList.class);
        return budgetDtoList;
    }

    @Override
    public List<SubComActivityPlanBudgetDto> newItem(String cacheKey, List<SubComActivityPlanBudgetDto> itemList) {
        return null;
    }

    @Override
    public List<SubComActivityPlanBudgetDto> copyItem(String cacheKey, List<SubComActivityPlanBudgetDto> itemList) {
        return null;
    }

    @Override
    public Object getDtoKey(SubComActivityPlanBudgetDto subComActivityPlanBudgetDto) {
        return subComActivityPlanBudgetDto.getId();
    }

    @Override
    public String getCheckedStatus(SubComActivityPlanBudgetDto subComActivityPlanBudgetDto) {
        return subComActivityPlanBudgetDto.getChecked();
    }

    @Override
    public void updateItem(String cacheKey, List<SubComActivityPlanBudgetDto> itemList) {

    }
}
