package com.biz.crm.tpm.business.subsidiary.activity.plan.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlanBudget;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository.SubComActivityPlanBudgetRepository;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanBudgetService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Slf4j
@Service
public class SubComActivityPlanBudgetServiceImpl implements SubComActivityPlanBudgetService {

    @Autowired(required = false)
    private SubComActivityPlanBudgetRepository subComActivityPlanBudgetRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 更据方预算版本编码删除
     * @param versionCode
     */
    @Override
    public void deleteBySubPlanCodes(List<String> versionCode) {
        if(CollectionUtils.isEmpty(versionCode)) {
            return;
        }
        this.subComActivityPlanBudgetRepository.deleteBySubPlanCodes(versionCode);
    }

    @Override
    public List<SubComActivityPlanBudgetVo> findBySubPlanCode(String versionCode) {
        if (StringUtils.isBlank(versionCode)) {
            return Lists.newArrayList();
        }
        List<SubComActivityPlanBudget> list = this.subComActivityPlanBudgetRepository.findBySubPlanCode(versionCode);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List<SubComActivityPlanBudgetVo>) nebulaToolkitService.copyCollectionByWhiteList(list,SubComActivityPlanBudget.class,SubComActivityPlanBudgetVo.class, HashSet.class, ArrayList.class);

    }

    @Override
    public void saveBudget(String subActivityPlanCode, List<SubComActivityPlanBudgetDto> budgetList) {
        if (CollectionUtils.isEmpty(budgetList) || StringUtils.isBlank(subActivityPlanCode)) {
            return;
        }
        //删除原来的数据
        this.subComActivityPlanBudgetRepository.remove(Wrappers.lambdaUpdate(SubComActivityPlanBudget.class).eq(SubComActivityPlanBudget::getSubActivityPlanCode, subActivityPlanCode));
        Collection<SubComActivityPlanBudget> planBudgets = nebulaToolkitService.copyCollectionByWhiteList(budgetList, SubComActivityPlanBudgetDto.class, SubComActivityPlanBudget.class, HashSet.class, ArrayList.class);
        this.subComActivityPlanBudgetRepository.saveBatch(planBudgets);
    }

    @Override
    public Page<SubComActivityPlanBudgetVo> findByProcessNoConditionsCreate(Pageable pageable, SubComActivityPlanBudgetDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        if (Objects.isNull(dto) || com.alibaba.excel.util.StringUtils.isBlank(dto.getProcessNo())) {
            return null;
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<SubComActivityPlanVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.subComActivityPlanBudgetRepository.findByProcessNoConditionsCreate(page,dto);
    }
}
