package com.biz.crm.tpm.business.subsidiary.activity.plan.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlanBudget;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlanItemFee;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository.SubComActivityPlanItemFeeRepository;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemFeeDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemFeeService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemFeeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Slf4j
@Service
public class SubComActivityPlanItemFeeServiceImpl implements SubComActivityPlanItemFeeService {

    @Autowired(required = false)
    private SubComActivityPlanItemFeeRepository subComActivityPlanItemFeeRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveBatch(List<SubComActivityPlanItemFeeDto> subPlanItemFeeList) {
        if (CollectionUtils.isEmpty(subPlanItemFeeList)) {
            return;
        }
        List<SubComActivityPlanItemFee> list = (List<SubComActivityPlanItemFee>) nebulaToolkitService.copyCollectionByWhiteList(subPlanItemFeeList, SubComActivityPlanItemFeeDto.class, SubComActivityPlanItemFee.class, HashSet.class, ArrayList.class);
        this.subComActivityPlanItemFeeRepository.saveBatch(list);
    }

    /**
     * 初始化方案内容使用明细 仅用于分子方案审批前编辑
     * @param subActivityPlanCode
     * @param itemCacheList
     */
    @Override
    public void saveItemFee(String subActivityPlanCode, List<SubComActivityPlanItemDto> itemCacheList) {
        if (StringUtils.isBlank(subActivityPlanCode) || CollectionUtils.isEmpty(itemCacheList)) {
            return;
        }
        //删除原来的数据。
        this.subComActivityPlanItemFeeRepository.remove(Wrappers.lambdaUpdate(SubComActivityPlanItemFee.class).eq(SubComActivityPlanItemFee::getSubActivityPlanCode, subActivityPlanCode));
        List<SubComActivityPlanItemFeeDto> list = new ArrayList<>();
        for (SubComActivityPlanItemDto item : itemCacheList) {
            if (!CollectionUtils.isEmpty(item.getItemFeeList())) {
                list.addAll(item.getItemFeeList());
            }
        }
        if (!CollectionUtils.isEmpty(list)) {
            Collection<SubComActivityPlanItemFee> entityList = nebulaToolkitService.copyCollectionByWhiteList(list, SubComActivityPlanItemFeeDto.class, SubComActivityPlanItemFee.class, HashSet.class, ArrayList.class);
            this.subComActivityPlanItemFeeRepository.saveBatch(entityList);

        }
    }

    /**
     * 通过规划编码获取分子方案使用明细，按使用先后倒序
     * @param activityDesignCode
     * @return
     */
    @Override
    public List<SubComActivityPlanItemFeeVo> findUsedByActivityDesignCode(String activityDesignCode) {
        if (StringUtils.isBlank(activityDesignCode)) {
            return Lists.newArrayList();
        }
        List<SubComActivityPlanItemFee> list = this.subComActivityPlanItemFeeRepository.findByActivityDesignCode(activityDesignCode);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List<SubComActivityPlanItemFeeVo>) nebulaToolkitService.copyCollectionByWhiteList(list,SubComActivityPlanItemFee.class,SubComActivityPlanItemFeeVo.class,HashSet.class,ArrayList.class);
    }

    @Override
    public SubComActivityPlanItemFeeVo findLastByItemCode(String itemCode) {
        if (StringUtils.isBlank(itemCode)) {
            return null;
        }
        return this.subComActivityPlanItemFeeRepository.findLastByItemCode(itemCode);
    }
}
