package com.biz.crm.tpm.business.subsidiary.activity.plan.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.constant.SubComActivityPlanConstant;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemFeeDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemFeeVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * @Description:分子公司方案-方案内容明细行分页缓存服务助手
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Component
public class SubComActivityPlanItemPageCacheHelper extends MnPageCacheHelper<SubComActivityPlanItemVo, SubComActivityPlanItemDto> {

    @Autowired(required = false)
    private SubComActivityPlanItemService subComActivityPlanItemService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private RedisTemplate<String, Object> redisTemplate;


    @Override
    public String getCacheKeyPrefix() {
        return SubComActivityPlanConstant.SUB_COM_ACTIVITY_PLAN_ITEM_CACHE_KEY_PREFIX;
    }

    @Override
    public Class<SubComActivityPlanItemDto> getDtoClass() {
        return SubComActivityPlanItemDto.class;
    }

    @Override
    public Class<SubComActivityPlanItemVo> getVoClass() {
        return SubComActivityPlanItemVo.class;
    }

    @Override
    public List<SubComActivityPlanItemDto> findDtoListFromRepository(SubComActivityPlanItemDto dto, String cacheKey) {
        if (StringUtils.isEmpty(dto.getSubActivityPlanCode())){
            return Lists.newArrayList();
        }



        //从数据库里面查出来放到缓存里面
        List<SubComActivityPlanItemVo> itemVoList = subComActivityPlanItemService.findBySubPlanCode(dto.getSubActivityPlanCode());
        List<SubComActivityPlanItemDto> itemDtoList = (List<SubComActivityPlanItemDto>) nebulaToolkitService.copyCollectionByBlankList(itemVoList, SubComActivityPlanItemVo.class, SubComActivityPlanItemDto.class, HashSet.class, ArrayList.class);
        itemDtoList.sort(Comparator.comparing(SubComActivityPlanItemDto::getSubActivityPlanItemCode));
        return itemDtoList;
    }

    @Override
    public List<SubComActivityPlanItemDto> newItem(String cacheKey, List<SubComActivityPlanItemDto> itemList) {
        SubComActivityPlanItemDto newItem = new SubComActivityPlanItemDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return Lists.newArrayList(newItem);
    }

    @Override
    public List<SubComActivityPlanItemDto> copyItem(String cacheKey, List<SubComActivityPlanItemDto> itemList) {
        List<SubComActivityPlanItemDto> newItemList = (List<SubComActivityPlanItemDto>) nebulaToolkitService.copyCollectionByBlankList(itemList, SubComActivityPlanItemDto.class, SubComActivityPlanItemDto.class, HashSet.class, ArrayList.class);
        for (SubComActivityPlanItemDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setSubActivityPlanItemCode(null);
        }
        return newItemList;
    }

    @Override
    public Object getDtoKey(SubComActivityPlanItemDto subComActivityPlanItemDto) {
        return subComActivityPlanItemDto.getId();
    }

    @Override
    public String getCheckedStatus(SubComActivityPlanItemDto subComActivityPlanItemDto) {
        return subComActivityPlanItemDto.getChecked();
    }

    /**
     * 导入新增数据
     *
     * @param cacheKey
     * @param itemList
     * @return
     */
    public void importNewItem(String cacheKey, List<SubComActivityPlanItemDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);

        //导入新增数据
        for (SubComActivityPlanItemDto newItem : itemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setTenantCode(TenantUtils.getTenantCode());
        }

        Object[] newIdArr = itemList.stream().map(this::getDtoKey).toArray();
        redisService.lPushAll(redisCacheIdKey, this.getExpireTime(), newIdArr);

        Map<Object, SubComActivityPlanItemDto> updateMap = itemList.stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
        redisTemplate.opsForHash().putAll(redisCacheDataKey, updateMap);
        redisService.expire(redisCacheDataKey, this.getExpireTime());
    }

    @Override
    public List<SubComActivityPlanItemVo> dtoListToVoList(List<SubComActivityPlanItemDto> dtoList){
        List<SubComActivityPlanItemVo> list = new ArrayList<>();
        if(CollectionUtils.isEmpty(dtoList)){
            return list;
        }
        for (SubComActivityPlanItemDto itemDto : dtoList) {
            SubComActivityPlanItemVo feeVo = this.nebulaToolkitService.copyObjectByBlankList(itemDto,this.getVoClass(),HashSet.class,ArrayList.class);
            if(!CollectionUtils.isEmpty(itemDto.getItemFeeList())){
                List<SubComActivityPlanItemFeeVo> itemFeeVoList = (List<SubComActivityPlanItemFeeVo>) this.nebulaToolkitService.copyCollectionByWhiteList(itemDto.getItemFeeList(), SubComActivityPlanItemFeeDto.class, SubComActivityPlanItemFeeVo.class, HashSet.class, ArrayList.class);
                feeVo.setItemFeeList(itemFeeVoList);
            }

            list.add(feeVo);
        }
        return list;
    }

    @Override
    public void updateItem(String cacheKey, List<SubComActivityPlanItemDto> itemList) {

    }
}
