package com.biz.crm.tpm.business.subsidiary.activity.plan.local.service.internal;

import com.alibaba.excel.util.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.ForecastOperationTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlanItem;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlanItemFee;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository.SubComActivityPlanItemFeeRepository;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository.SubComActivityPlanItemRepository;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.constant.SubComActivityPlanConstant;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemFeeDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.enums.SubPlanStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemFeeService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemFeeVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Description:分子活动方案-方案内容明细  --服务
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Slf4j
@Service
public class SubComActivityPlanItemServiceImpl implements SubComActivityPlanItemService {

    @Autowired(required = false)
    private SubComActivityPlanItemRepository subComActivityPlanItemRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private SubComActivityPlanItemFeeRepository subComActivityPlanItemFeeRepository;

    @Autowired(required = false)
    private ProcessBatchBusinessService processBatchBusinessService;

    @Autowired(required = false)
    private SubComActivityPlanItemFeeService subComActivityPlanItemFeeService;

    /**
     * 保存方案内容明细行
     *
     * @param dto
     * @param itemCacheList
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveItem(boolean update,SubComActivityPlanDto dto, List<SubComActivityPlanItemDto> itemCacheList) {
        if (Objects.isNull(dto) || StringUtils.isBlank(dto.getSubActivityPlanCode()) || CollectionUtils.isEmpty(itemCacheList)){
            return;
        }
        Map<String, SubComActivityPlanItem> oldMap = Maps.newHashMap();
        List<SubComActivityPlanItem> oldList = new ArrayList<>();
        if (update) {
             oldList = subComActivityPlanItemRepository.findBySubPlanCode(dto.getSubActivityPlanCode());
            oldMap = oldList.stream().collect(Collectors.toMap(SubComActivityPlanItem::getId, Function.identity()));
        }

        List<SubComActivityPlanItem> itemList = (List<SubComActivityPlanItem>) nebulaToolkitService.copyCollectionByWhiteList(
                itemCacheList, SubComActivityPlanItemDto.class, SubComActivityPlanItem.class, HashSet.class, ArrayList.class
        );
        List<SubComActivityPlanItem> saveList = Lists.newArrayList();
        List<SubComActivityPlanItem> updateList = Lists.newArrayList();
        for (SubComActivityPlanItem item : itemList) {
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
                oldMap.remove(item.getId());
            } else {
                item.setId(null);
                saveList.add(item);
            }
        }
        if (!CollectionUtils.isEmpty(saveList)) {

            subComActivityPlanItemRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            subComActivityPlanItemRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            //待删除的数据
            subComActivityPlanItemRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
            List<String> itemCodes = new ArrayList<>(oldMap.size());
            oldMap.forEach( (k,v) ->{
                itemCodes.add(v.getSubActivityPlanItemCode());
            });
            subComActivityPlanItemFeeRepository.deleteByItemCodes(itemCodes);
        }

    }

    /**
     * 更据分子方案编码删除
     * @param subPlanCodes
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBySubPlanCodes(List<String> subPlanCodes) {
        if (CollectionUtils.isEmpty(subPlanCodes)) {
            return;
        }
        List<SubComActivityPlanItem> itemList = subComActivityPlanItemRepository.findBySubPlanCodes(subPlanCodes);
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        List<String> itemCodes = itemList.stream().map(SubComActivityPlanItem::getSubActivityPlanItemCode).distinct().collect(Collectors.toList());
        List<String> ids = itemList.stream().map(SubComActivityPlanItem::getId).distinct().collect(Collectors.toList());

        subComActivityPlanItemRepository.deleteByIds(ids);
        subComActivityPlanItemFeeRepository.deleteByItemCodes(itemCodes);

    }

    @Override
    public List<SubComActivityPlanItemVo> findBySubPlanCodes(List<String> subPlanCodes) {
        if (CollectionUtils.isEmpty(subPlanCodes)) {
            return Lists.newArrayList();
        }
        List<SubComActivityPlanItem> itemList = this.subComActivityPlanItemRepository.findBySubPlanCodes(subPlanCodes);
        if (CollectionUtils.isEmpty(itemList)) {
            return Lists.newArrayList();
        }
        return (List<SubComActivityPlanItemVo>) nebulaToolkitService.copyCollectionByWhiteList(itemList, SubComActivityPlanItem.class, SubComActivityPlanItemVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    public List<SubComActivityPlanItemVo> findBySubPlanCode(String subPlanCode) {
        if (StringUtils.isBlank(subPlanCode)) {
            return Lists.newArrayList();
        }
        List<SubComActivityPlanItem> itemList = this.subComActivityPlanItemRepository.findBySubPlanCode(subPlanCode);
        if (CollectionUtils.isEmpty(itemList)) {
            return Lists.newArrayList();
        }
        return (List<SubComActivityPlanItemVo>) nebulaToolkitService.copyCollectionByWhiteList(itemList, SubComActivityPlanItem.class, SubComActivityPlanItemVo.class, HashSet.class, ArrayList.class);

    }

    @Override
    public Page<SubComActivityPlanItemVo> closeFindItem(Pageable pageable, SubComActivityPlanItemDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new SubComActivityPlanItemDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<SubComActivityPlanVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.subComActivityPlanItemRepository.closeFindItem(page,dto);
    }

    @Override
    public void closeSubmitApproval(SubComActivityPlanApproveSubmitDto dto) {
        List<SubComActivityPlanItem> itemList = subComActivityPlanItemRepository.listByIds(dto.getIds());
        Validate.notEmpty(itemList,"要关闭的方案不存在！");
        itemList.forEach(item -> {
            if (SubPlanStatusEnum.EXECUTING.getCode().equals(item.getActivityStatus())
                    || SubPlanStatusEnum.CLOSE_REJECT.getCode().equals(item.getActivityStatus())) {

            }else {
                throw new IllegalArgumentException("只有 ’执行中 / 关闭审批驳回’ 状态的方案内容才可关闭！");
            }
        });
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.notNull(processBusiness, "提交工作流时，未传工作流对象信息!");
        processBusiness.setBusinessNoList(dto.getIds());
        String businessNo = UUID.randomUUID().toString().replace("-","");
        processBusiness.setBusinessNo(businessNo);
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString(dto));
        processBusiness.setBusinessCode(SubComActivityPlanConstant.CLOSE_PROCESS_CODE);
        ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusiness);

        itemList.forEach(detail -> {
            detail.setItemProcessNo(processBusinessVo.getProcessNo());
            detail.setActivityStatus(SubPlanStatusEnum.CLOSE_COMMIT.getCode());

        });
        subComActivityPlanItemRepository.updateBatchById(itemList);
    }

    @Override
    public Page<SubComActivityPlanItemVo> findByItemProcessNo(Pageable pageable, String itemProcessNo) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        Page<SubComActivityPlanVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Validate.notBlank(itemProcessNo,"流程编码不能为空！");
        return this.subComActivityPlanItemRepository.findByItemProcessNo(page,itemProcessNo);
    }

    @Override
    public List<SubComActivityPlanItemVo> findByItemCodes(List<String> itemCodes) {
        if (CollectionUtils.isEmpty(itemCodes)) {
            return Lists.newArrayList();
        }
        List<SubComActivityPlanItem> list = this.subComActivityPlanItemRepository.findByItemCodes(itemCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List<SubComActivityPlanItemVo>) nebulaToolkitService.copyCollectionByWhiteList(list,SubComActivityPlanItem.class,SubComActivityPlanItemVo.class,HashSet.class,ArrayList.class);
    }

    @Override
    public void updateActivityStatusByProcessNo(List<String> planCodes, String status) {
        if (CollectionUtils.isEmpty(planCodes) || StringUtils.isBlank(status)) {
            return;
        }
        this.subComActivityPlanItemRepository.updateActivityStatusByPlanCodes(planCodes,status);
    }

    @Override
    public Page<SubComActivityPlanItemFeeVo> findItemFeeByItemCode(Pageable pageable, String itemCode) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        Page<SubComActivityPlanItemFeeVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Validate.notBlank(itemCode,"方案明细编码不能为空！");
        return this.subComActivityPlanItemFeeRepository.findItemFeeByItemCode(page,itemCode);
    }

    /**
     * 关闭审批驳回、追回
     * @param processNo
     * @param status
     */
    @Override
    public void closeFailProcessBusiness(String processNo, String status) {
        if (StringUtils.isBlank(processNo)) {
            return;
        }
        this.subComActivityPlanItemRepository.updateActivityStatusByProcessNo(processNo,status);
    }

    /**
     * 关闭审批同
     * @param processNo
     * @param status
     */
    @Override
    public void closePassProcessBusiness(String processNo, String status) {
        if (StringUtils.isBlank(processNo)) {
            return;
        }
        this.subComActivityPlanItemRepository.updateActivityStatusByProcessNo(processNo,status);
    }

    @Override
    public Page<SubComActivityPlanItemVo> findPlanItemByConditions(Pageable pageable, SubComActivityPlanItemDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        Page<SubComActivityPlanVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        if (Objects.isNull(dto)) {
            dto = new SubComActivityPlanItemDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.subComActivityPlanItemRepository.findPlanItemByConditions(page,dto);
    }

    /**
     * 规划关闭生成对应方案内容预算使用记录
     * @param subPlanItemFeeDtoList
     */
    @Override
    public void generateItemFeeByDesignClosed(List<SubComActivityPlanItemFeeDto> subPlanItemFeeDtoList) {
        if (CollectionUtils.isEmpty(subPlanItemFeeDtoList)) {
            return;
        }
        Map<String, List<SubComActivityPlanItemFeeDto>> itemFeeDtoMap = subPlanItemFeeDtoList.stream().collect(Collectors.groupingBy(SubComActivityPlanItemFeeDto::getSubActivityPlanItemCode));
        List<SubComActivityPlanItem> itemList = this.subComActivityPlanItemRepository.findByItemCodes(Lists.newArrayList(itemFeeDtoMap.keySet()));
        List<SubComActivityPlanItem> updateItemList = new ArrayList<>();
        List<SubComActivityPlanItemFee> createItemFeeList = new ArrayList<>();
        Map<String, SubComActivityPlanItem> itemMap = itemList.stream().collect(Collectors.toMap(SubComActivityPlanItem::getSubActivityPlanItemCode, Function.identity()));
        itemMap.forEach((k,v) -> {
            SubComActivityPlanItemFeeVo lastItemFee = this.subComActivityPlanItemFeeRepository.findLastByItemCode(k);
            List<SubComActivityPlanItemFeeDto> itemFeeList = itemFeeDtoMap.get(k);
            BigDecimal beforeAmount = Optional.ofNullable(lastItemFee.getBalanceAmount()).orElse(BigDecimal.ZERO);
            Date date = new Date();
            BigDecimal residueAmount = BigDecimal.ZERO;
            for (int i = 0 ; i < itemFeeList.size(); i++ ) {
                SubComActivityPlanItemFeeDto feeDto = itemFeeList.get(i);
                SubComActivityPlanItemFee fee = nebulaToolkitService.copyObjectByWhiteList(feeDto, SubComActivityPlanItemFee.class, HashSet.class, ArrayList.class);
                fee.setBeforeAmount(beforeAmount);
                BigDecimal curOperationAmount = Optional.ofNullable(fee.getCurOperationAmount()).orElse(BigDecimal.ZERO);
                BigDecimal balanceAmount = beforeAmount.add(curOperationAmount);
                fee.setBalanceAmount(balanceAmount);
                fee.setOperationType(ForecastOperationTypeEnum.RETURN.getCode());
                fee.setTenantCode(TenantUtils.getTenantCode());
                fee.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                fee.setSubActivityPlanItemCode(k);
                fee.setSubActivityPlanItemName(v.getSubActivityPlanItemName());
                fee.setInitialAmount(lastItemFee.getInitialAmount());
                fee.setSortAsc(Long.parseLong(DateUtil.format(date,DateUtil.DEFAULT_DATE_TIME_PATTERN+i)));
                fee.setSubActivityPlanCode(v.getSubActivityPlanCode());
                fee.setSubActivityPlanItemCode(v.getSubActivityPlanItemCode());
                fee.setSubActivityPlanItemName(v.getSubActivityPlanItemName());
                fee.setInitialAmount(lastItemFee.getInitialAmount());
                fee.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
                residueAmount = residueAmount.add(curOperationAmount);

                beforeAmount = balanceAmount;
                createItemFeeList.add(fee);
            }

            v.setResidueAmount(v.getResidueAmount().add(residueAmount));
            v.setUsedAmount(v.getUsedAmount().subtract(residueAmount));
            updateItemList.add(v);
        });

        if (!CollectionUtils.isEmpty(updateItemList)) {
            this.subComActivityPlanItemRepository.updateBatchById(updateItemList);
        }
        if (!CollectionUtils.isEmpty(createItemFeeList)) {

        }
        return;
    }

    /**
     * 使用金额记录
     * @param subPlanItemFeeList
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void useSubPlanItemFee(List<SubComActivityPlanItemFeeDto> subPlanItemFeeList) {
        if (CollectionUtils.isEmpty(subPlanItemFeeList)) {
            return;
        }
        log.info("分子方案使用金额记录1");
        List<SubComActivityPlanItemFeeDto> collect = subPlanItemFeeList.stream().filter(f -> !ForecastOperationTypeEnum.USE.getCode().equals(f.getOperationType())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            throw new IllegalArgumentException("仅限操作类型为‘使用’。");
        }
        log.info("分子方案使用金额记录2");
        Map<String, List<SubComActivityPlanItemFeeDto>> subPlanItemFeeMap = subPlanItemFeeList.stream().collect(Collectors.groupingBy(SubComActivityPlanItemFeeDto::getSubActivityPlanItemCode));
        List<SubComActivityPlanItem> itemList = this.subComActivityPlanItemRepository.findByItemCodes(Lists.newArrayList(subPlanItemFeeMap.keySet()));
        Map<String, SubComActivityPlanItem> itemMap = itemList.stream().collect(Collectors.toMap(SubComActivityPlanItem::getSubActivityPlanItemCode, Function.identity()));
        List<SubComActivityPlanItem> updateList = new ArrayList<>();
        subPlanItemFeeMap.forEach((k,v) -> {
            SubComActivityPlanItem item = itemMap.get(k);
            Validate.notNull(item,"分子方案使用金额记录时，未查询到方案内容");
            BigDecimal reduce = v.stream().map(SubComActivityPlanItemFeeDto::getCurOperationAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal residueAmount = Optional.ofNullable(item.getResidueAmount()).orElse(BigDecimal.ZERO);
            BigDecimal usedAmount = Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO);
            item.setResidueAmount(residueAmount.subtract(reduce));
            item.setUsedAmount(usedAmount.add(reduce));
            log.info("分子方案使用金额记录3,方案:{},剩余:{}",item.getSubActivityPlanItemCode(),item.getResidueAmount());
            log.info("分子方案使用金额记录4,方案:{},已用:{}",item.getSubActivityPlanItemCode(),item.getUsedAmount());

            updateList.add(item);
        });
        this.subComActivityPlanItemRepository.updateBatchById(updateList);
        this.subComActivityPlanItemFeeService.saveBatch(subPlanItemFeeList);
    }

    @Override
    public void updateReturnAmount(List<SubComActivityPlanItemDto> updateSubPlanItemList) {
        if (CollectionUtils.isEmpty(updateSubPlanItemList)) {
            return;
        }
        this.subComActivityPlanItemRepository.updateReturnAmount(updateSubPlanItemList);
    }

    @Override
    public Page<SubComActivityPlanItemVo> findByProcessNoConditionsCreate(Pageable pageable, SubComActivityPlanItemDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        if (Objects.isNull(dto) || StringUtils.isBlank(dto.getProcessNo())) {
            return null;
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<SubComActivityPlanVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<SubComActivityPlanItemVo> resultPage = this.subComActivityPlanItemRepository.findByProcessNoConditionsCreate(page, dto);
        if (Objects.isNull(resultPage) || org.springframework.util.CollectionUtils.isEmpty(resultPage.getRecords())) {
            return resultPage;
        }
        List<SubComActivityPlanItemVo> detailList = resultPage.getRecords();
        detailList.forEach(detail -> {
            //费销比 = 费用合计 / 预估销售额
            if (Objects.isNull(detail.getExpectSalesAmount()) || BigDecimal.ZERO.compareTo(detail.getExpectSalesAmount()) == 0) {
                detail.setCostSalesRatio(BigDecimal.ZERO);
            }else {
                BigDecimal totalCost = Optional.ofNullable(detail.getTotalCost()).orElse(BigDecimal.ZERO);
                detail.setCostSalesRatio(totalCost.divide(detail.getExpectSalesAmount(), 2, BigDecimal.ROUND_HALF_UP));
            }

        });

        return resultPage;
    }
}
