package com.biz.crm.tpm.business.subsidiary.activity.plan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.ForecastOperationTypeEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.entity.SubComActivityPlan;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.repository.SubComActivityPlanRepository;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.service.SubComActivityPlanBudgetCacheService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.local.service.SubComActivityPlanItemCacheService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.constant.SubComActivityPlanConstant;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.*;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.enums.SubPlanStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.event.SubPlanCallSubActivityDesignEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanBudgetService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemFeeService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.model.EventResponse;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @Description:分子活动方案 --服务
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Slf4j
@Service
public class SubComActivityPlanServiceImpl implements SubComActivityPlanService {

    @Autowired(required = false)
    private SubComActivityPlanRepository subComActivityPlanRepository;

    @Autowired(required = false)
    private SubComActivityPlanItemService subComActivityPlanItemService;

    @Autowired(required = false)
    private SubComActivityPlanItemCacheService subComActivityPlanItemCacheService;

    @Autowired(required = false)
    private SubComActivityPlanBudgetService subComActivityPlanBudgetService;

    @Autowired(required = false)
    private SubComActivityPlanBudgetCacheService subComActivityPlanBudgetCacheService;

    @Autowired(required = false)
    private SubComActivityPlanItemFeeService subComActivityPlanItemFeeService;

    @Autowired(required = false)
    private ProcessBatchBusinessService processBatchBusinessService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private SubComBudgetForecastService subComBudgetForecastService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;



    /**
     * 查询分页列表
     *
     * @param pageable
     * @param dto
     * @return
     */
    @Override
    public Page<SubComActivityPlanVo> findByConditions(Pageable pageable, SubComActivityPlanDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new SubComActivityPlanDto());
        Page<SubComActivityPlanVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.subComActivityPlanRepository.findByConditions(page,dto);
    }

    /**
     * 新增编辑
     *
     * @param dto
     * @param cacheKey
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void create(SubComActivityPlanDto dto, String cacheKey) {
        this.validateValue(dto);

        List<SubComActivityPlanItemDto> itemCacheList = new ArrayList<>();
        if (StringUtils.isNotEmpty(cacheKey)) {
            //获取缓存明细集合
            itemCacheList = subComActivityPlanItemCacheService.findCacheList(cacheKey);
        } else {
            itemCacheList = dto.getItemList();
        }

        //查询生成分子预算预测信息
        List<SubComActivityPlanBudgetDto> budgetList = this.findAndBuildBudgetDate(dto,itemCacheList);
        dto.setBudgetList(budgetList);

        //明细必填校验、金额汇总、方案内容明细初始化
        this.validateItemValueAndGenerateItemFee(dto,itemCacheList);
        //保存
        this.savePlanAndItem(dto,itemCacheList);

    }

    @Transactional(rollbackFor = Exception.class)
    public void savePlanAndItem(SubComActivityPlanDto dto, List<SubComActivityPlanItemDto> itemCacheList) {
        SubComActivityPlan entity = null;
        boolean update = StringUtils.isNotBlank(dto.getId());

        if (update) {
            SubComActivityPlan old = subComActivityPlanRepository.getById(dto.getId());
            Validate.notNull(old,"要修改是数据不存在！");
            Validate.isTrue(ProcessStatusEnum.PREPARE.getDictCode().equals(old.getProcessStatus())
                    || ProcessStatusEnum.REJECT.getDictCode().equals(old.getProcessStatus())
                    || ProcessStatusEnum.RECOVER.getDictCode().equals(old.getProcessStatus()), "只能修改处于驳回，追回，待提交状态的分子活动方案");
            dto.setSubActivityPlanCode(old.getSubActivityPlanCode());
            dto.setTenantCode(old.getTenantCode());
            entity = nebulaToolkitService.copyObjectByWhiteList(dto, SubComActivityPlan.class, HashSet.class, ArrayList.class);
            subComActivityPlanRepository.updateById(entity);

        }else {
            entity = nebulaToolkitService.copyObjectByWhiteList(dto, SubComActivityPlan.class, HashSet.class, ArrayList.class);
            // redis生成方案编码
            String code = this.generateCodeService.generateCode(SubComActivityPlanConstant.SUB_COM_ACTIVITY_PLAN_RULE_CODE_PRE, 1, 6, -1, TimeUnit.DAYS).get(0);
            entity.setSubActivityPlanCode(code);
            dto.setSubActivityPlanCode(code);
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setTenantCode(TenantUtils.getTenantCode());
            this.subComActivityPlanRepository.save(entity);
        }

        this.buildCommonCode(dto,itemCacheList);

        subComActivityPlanItemService.saveItem(update,dto,itemCacheList);

        subComActivityPlanBudgetService.saveBudget(dto.getSubActivityPlanCode(),dto.getBudgetList());

        subComActivityPlanItemFeeService.saveItemFee(dto.getSubActivityPlanCode(),itemCacheList);

        //日志

    }


    private List<SubComActivityPlanBudgetDto> findAndBuildBudgetDate(SubComActivityPlanDto dto, List<SubComActivityPlanItemDto> itemCacheList) {
        Pageable pageable = Pageable.ofSize(1000);
        SubComActivityPlanBudgetDto selectDto = new SubComActivityPlanBudgetDto();
        selectDto.setYearMonthLy(dto.getFeeYearMonth());
        selectDto.setOrgCode(dto.getOrgCode());
        List<SubComActivityPlanBudgetDto> planBudgetList = null;
        SubComActivityPlanBudgetDto budgetDto = new SubComActivityPlanBudgetDto();
        budgetDto.setOrgCode(dto.getOrgCode());
        budgetDto.setFeeYearMonth(dto.getFeeYearMonth());
        Page<SubComActivityPlanBudgetVo> planBudgetPage = this.findSubBudgetForecastByConditions(pageable, budgetDto, itemCacheList);
        Optional<Long> total = Optional.ofNullable(planBudgetPage).map(Page::getTotal);
        if (total.isPresent()) {
            planBudgetList = new ArrayList<>(total.get().intValue());
            planBudgetList.addAll(
                    nebulaToolkitService.copyCollectionByWhiteList(planBudgetPage.getRecords(),SubComActivityPlanBudgetVo.class,SubComActivityPlanBudgetDto.class,HashSet.class,ArrayList.class)
            );
            while (planBudgetPage.hasNext()) {
                pageable = pageable.next();
                planBudgetPage = this.findSubBudgetForecastByConditions(pageable, null, itemCacheList);
                planBudgetList.addAll(
                        nebulaToolkitService.copyCollectionByWhiteList(planBudgetPage.getRecords(),SubComActivityPlanBudgetVo.class,SubComActivityPlanBudgetDto.class,HashSet.class,ArrayList.class)
                );
            }
        }

        if (CollectionUtils.isEmpty(planBudgetList)) {
            return Lists.newArrayList();
        }
        return planBudgetList;
    }


    /**
     *
     * @param dto
     * @param itemCacheList
     */
    private void buildCommonCode(SubComActivityPlanDto dto, List<SubComActivityPlanItemDto> itemCacheList) {
        long count = itemCacheList.stream().filter(itemCache -> StringUtils.isEmpty(itemCache.getSubActivityPlanItemCode())).count();
        List<String> codeList = Lists.newArrayList();
        if (count > 0) {
           codeList = this.generateCodeService.generateCode(SubComActivityPlanConstant.SUB_COM_ACTIVITY_PLAN_ITEM_RULE_CODE_PRE, (int) count, 8, 1, TimeUnit.DAYS);
       }
        Iterator<String> codeIt = codeList.iterator();
        String tenantCode = TenantUtils.getTenantCode();

        //方案内容明细
        itemCacheList.forEach(item -> {
            if (StringUtils.isBlank(item.getSubActivityPlanItemCode())){
                item.setSubActivityPlanItemCode(codeIt.next());
            }
            item.setSubActivityPlanCode(dto.getSubActivityPlanCode());
            item.setSubActivityPlanName(dto.getSubActivityPlanName());
            item.setTenantCode(tenantCode);
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setActivityStatus(SubPlanStatusEnum.CREATE.getCode());

            if (!CollectionUtils.isEmpty(item.getItemFeeList())) {
                item.getItemFeeList().forEach(fee -> {
                    fee.setBusinessUnitCode(dto.getBusinessUnitCode());
                    fee.setSubActivityPlanCode(dto.getSubActivityPlanCode());
                    fee.setSubActivityPlanName(dto.getSubActivityPlanName());
                    fee.setSubActivityPlanItemCode(item.getSubActivityPlanItemCode());
                    fee.setSubActivityPlanItemName(item.getSubActivityPlanItemName());
                    fee.setTenantCode(tenantCode);
                    fee.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                });
            }

        });

        //方案预算信息
        if (!CollectionUtils.isEmpty(dto.getBudgetList())) {
            dto.getBudgetList().forEach(budget -> {
                budget.setSubActivityPlanCode(dto.getSubActivityPlanCode());
                budget.setTenantCode(tenantCode);
                budget.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
        }

    }

    /**
     * 方案内容明细行
     *      1、新增编辑校验
     *      2、金额汇总
     *      3、生成使用预算明细初始行
     *
     * @param dto
     * @param itemCacheList
     */
    private void validateItemValueAndGenerateItemFee(SubComActivityPlanDto dto, List<SubComActivityPlanItemDto> itemCacheList) {

        Validate.notEmpty(itemCacheList,"方案内容明细行不能为空！");
        //方案金额
        BigDecimal applyAmount = BigDecimal.ZERO;
        //预计销售额
        BigDecimal salesAmount = BigDecimal.ZERO;
        Date date = new Date();
        for (SubComActivityPlanItemDto item : itemCacheList) {

            Validate.notBlank(item.getOrgCode(),"执行部门编码不能为空！");
            Validate.notBlank(item.getOrgName(),"执行部门名称不能为空！");
            Validate.notBlank(item.getActivityFormCode(),"活动形式编码不能为空！");
            Validate.notBlank(item.getActivityFormName(),"活动形式名称行不能为空！");
            Validate.notBlank(item.getActivityTypeCode(),"活动分类编码行不能为空！");
            Validate.notBlank(item.getActivityTypeName(),"活动分类名称行不能为空！");
            Validate.notBlank(item.getBudgetItemCode(),"预算项目编码不能为空！");
            Validate.notBlank(item.getBudgetItemName(),"预算项目名称不能为空！");
            Validate.notBlank(item.getFeeSourceCode(),"费用来源不能为空！");
            Validate.notNull(item.getTotalCost(),"费用金额不能为空！");
            Validate.notNull(item.getExpectSalesAmount(),"预计销售额不能为空！");
            BigDecimal totalCost = Optional.ofNullable(item.getTotalCost()).orElse(BigDecimal.ZERO);
            BigDecimal expectSalesAmount = Optional.ofNullable(item.getExpectSalesAmount()).orElse(BigDecimal.ZERO);
            applyAmount = applyAmount.add(totalCost);
            salesAmount = salesAmount.add(expectSalesAmount);
            item.setFeeYearMonth(dto.getFeeYearMonth());

            //使用明细初始化
            SubComActivityPlanItemFeeDto feeDto = new SubComActivityPlanItemFeeDto();
            feeDto.setSubActivityPlanItemName(item.getSubActivityPlanItemName());
            feeDto.setBudgetItemCode(item.getBudgetItemCode());
            feeDto.setBudgetItemName(item.getBudgetItemName());
            feeDto.setInitialAmount(item.getTotalCost());
            feeDto.setBeforeAmount(BigDecimal.ZERO);
            feeDto.setCurOperationAmount(item.getTotalCost());
            feeDto.setBalanceAmount(item.getTotalCost());
            feeDto.setOperationType(ForecastOperationTypeEnum.INIT.getCode());
            feeDto.setSortAsc(Long.parseLong(DateUtil.format(date, DateUtil.DEFAULT_DATE_TIME_PATTERN)+"0"));
            List<SubComActivityPlanItemFeeDto> feeDtoList = new ArrayList<>();
            feeDtoList.add(feeDto);
            item.setItemFeeList(feeDtoList);

            item.setResidueAmount(item.getTotalCost());
            item.setUsedAmount(BigDecimal.ZERO);
        }

        dto.setApplyAmount(applyAmount);
        dto.setSalesAmount(salesAmount);
    }


    /**
     * 新增编辑校验
     *
     * @param dto
     */
    private void validateValue(SubComActivityPlanDto dto) {
        Validate.notBlank(dto.getSubActivityPlanName(),"方案名称不能为空!");
        if (StringUtils.isBlank(dto.getSubActivityPlanType())) {
            dto.setSubActivityPlanType("1");
        }
        if (StringUtils.isBlank(dto.getBusinessFormatCode())) {
            dto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        }
        if (StringUtils.isBlank(dto.getBusinessUnitCode())) {
            dto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
        }
        Validate.notBlank(dto.getFeeYearMonth(),"年月不能为空!");
        Validate.notBlank(dto.getOrgCode(),"分子公司编码不能为空!");
        Validate.notBlank(dto.getOrgCode(),"分子公司名称不能为空!");
    }

    /**
     * 删除数据
     *
     * @param ids
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("请选择要删除数据！");
        }
        List<SubComActivityPlan> subPlanList = this.subComActivityPlanRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(subPlanList)) {
            return;
        }
        List<SubComActivityPlan> passList = subPlanList.stream()
                .filter(x -> ProcessStatusEnum.PASS.getDictCode().equals(x.getProcessStatus())
                        || ProcessStatusEnum.COMMIT.getDictCode().equals(x.getProcessStatus())
                        || ProcessStatusEnum.COLSE.getDictCode().equals(x.getProcessStatus()))
                .collect(Collectors.toList());
        Validate.isTrue(CollectionUtils.isEmpty(passList), "审批通过、审批中、已关闭的数据不允许删除！！！");

        subPlanList.forEach(plan -> {
            plan.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        });
        List<String> subPlanCodes = subPlanList.stream().map(SubComActivityPlan::getSubActivityPlanCode).distinct().collect(Collectors.toList());
        this.subComActivityPlanRepository.updateBatchById(subPlanList);
        this.subComActivityPlanItemService.deleteBySubPlanCodes(subPlanCodes);

    }

    /**
     * 提交审批
     *
     * @param dto
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void submitApproval(SubComActivityPlanApproveSubmitDto dto) {
        List<SubComActivityPlan> entityList = subComActivityPlanRepository.listByIds(dto.getIds(),DelFlagStatusEnum.NORMAL.getCode());
        Validate.isTrue(!CollectionUtils.isEmpty(entityList),"实例对象不存在！！");

        List<String> planCodes = new ArrayList<>(entityList.size());
        for (SubComActivityPlan entity : entityList) {
            //待提交、驳回、追回的数据才能提交
            if (!ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) &&
                    !ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()) &&
                    !ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus())){
                throw new RuntimeException("分子公司活动方案["+entity.getSubActivityPlanCode()+"]不处于待提交、驳回、追回状态，不能提交审批！");
            }
            planCodes.add(entity.getSubActivityPlanCode());
        }

        this.commitProcess(planCodes,dto);
    }

    private void commitProcess(List<String> planCodes,SubComActivityPlanApproveSubmitDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.notNull(processBusiness, "提交工作流时，未传工作流对象信息!");
        processBusiness.setBusinessNoList(dto.getIds());
        String businessNo = UUID.randomUUID().toString().replace("-","");
        processBusiness.setBusinessNo(businessNo);
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString(dto));
        processBusiness.setBusinessCode(SubComActivityPlanConstant.PROCESS_CODE);
        ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusiness);

        this.subComActivityPlanRepository.updateProcessStatusAndProcessNo(dto.getIds(),ProcessStatusEnum.COMMIT.getDictCode(),processBusinessVo.getProcessNo());

        //这里只是同步更新下明细上的状态为审批中，不希望影响到上面真正提交的流程。故没加事务。
        this.subComActivityPlanItemService.updateActivityStatusByProcessNo(planCodes,SubPlanStatusEnum.COMMIT.getCode());
    }

    /**
     * 审批通过
     *
     * @param processNo
     * @param processStatus
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void passProcessBusiness(String processNo, String processStatus) {
        if (StringUtils.isBlank(processNo)) {
            return;
        }
        List<String> planCodes = this.subComActivityPlanRepository.findPlanCodeByProcessNo(processNo);
        if (CollectionUtils.isEmpty(planCodes)) {
            return;
        }
        this.subComActivityPlanRepository.updateProcessStatusByProcessNo(processNo,processStatus);
        this.subComActivityPlanItemService.updateActivityStatusByProcessNo(planCodes,SubPlanStatusEnum.EXECUTING.getCode());
    }

    /**
     * 审批驳回、追回
     * @param processNo
     * @param processStatus
     */
    @Override
    @Transactional
    public void failProcessBusiness(String processNo, String processStatus) {
        if (StringUtils.isBlank(processNo)) {
            return;
        }
        List<String> planCodes = this.subComActivityPlanRepository.findPlanCodeByProcessNo(processNo);
        if (CollectionUtils.isEmpty(planCodes)) {
            return;
        }
        this.subComActivityPlanRepository.updateProcessStatusByProcessNo(processNo,processStatus);
        this.subComActivityPlanItemService.updateActivityStatusByProcessNo(planCodes,SubPlanStatusEnum.CREATE.getCode());
    }

    /**
     * 更据流程编码查详情
     * @param processNo
     * @return
     */
    @Override
    public List<SubComActivityPlanVo> findByProcessNo(String processNo) {
        if (StringUtils.isBlank(processNo)) {
            return Lists.newArrayList();
        }
        List<SubComActivityPlanVo> planList = this.subComActivityPlanRepository.findByProcessNo(processNo);
        if (!CollectionUtils.isEmpty(planList)) {
            return Lists.newArrayList();
        }
        List<String> subPlanCodes = planList.stream().map(SubComActivityPlanVo::getSubActivityPlanCode).distinct().collect(Collectors.toList());
        List<SubComActivityPlanItemVo> planItemList = this.subComActivityPlanItemService.findBySubPlanCodes(subPlanCodes);
        Map<String, List<SubComActivityPlanItemVo>> planItemMap = planItemList.stream().collect(Collectors.groupingBy(SubComActivityPlanItemVo::getSubActivityPlanCode));
        planList.forEach(plan -> {
            List<SubComActivityPlanItemVo> items = planItemMap.get(plan.getSubActivityPlanCode());
            plan.setItemList(items);
        });
        return planList;
    }

    /**
     * 通过id查详情
     * @param ids
     * @return
     */
    @Override
    public List<SubComActivityPlanVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<SubComActivityPlan> planList = this.subComActivityPlanRepository.listByIds(ids);
        if (!CollectionUtils.isEmpty(planList)) {
            return Lists.newArrayList();
        }
        List<String> subPlanCodes = planList.stream().map(SubComActivityPlan::getSubActivityPlanCode).distinct().collect(Collectors.toList());
        List<SubComActivityPlanItemVo> planItemList = this.subComActivityPlanItemService.findBySubPlanCodes(subPlanCodes);

        List<SubComActivityPlanVo> planVos = (List<SubComActivityPlanVo>) nebulaToolkitService.copyCollectionByWhiteList(planList, SubComActivityPlan.class, SubComActivityPlanVo.class, HashSet.class, ArrayList.class);
        Map<String, List<SubComActivityPlanItemVo>> planItemMap = planItemList.stream().collect(Collectors.groupingBy(SubComActivityPlanItemVo::getSubActivityPlanCode));
        planVos.forEach(plan -> {
            List<SubComActivityPlanItemVo> items = planItemMap.get(plan.getSubActivityPlanCode());
            plan.setItemList(items);
        });
        return planVos;
    }

    /**
     * 更据id查详情
     * @param id
     * @return
     */
    @Override
    public SubComActivityPlanVo findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        SubComActivityPlan plan = this.subComActivityPlanRepository.getById(id);
        if (Objects.isNull(plan)) {
            return null;
        }
        SubComActivityPlanVo planVo = nebulaToolkitService.copyObjectByWhiteList(plan, SubComActivityPlanVo.class, HashSet.class, ArrayList.class);
        return planVo;
    }

    /**
     * 分页查询分子预算预测信息
     * @param pageable
     * @param dto
     * @return
     */
    @Override
    public Page<SubComActivityPlanBudgetVo> findSubBudgetForecastByConditions(Pageable pageable, SubComActivityPlanBudgetDto dto,List<SubComActivityPlanItemDto> itemCacheList) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new SubComActivityPlanBudgetDto());
        SubComBudgetForecastDto selectDto = new SubComBudgetForecastDto();

        //分页查询结果
        Page<SubComActivityPlanBudgetVo> resultPage = new Page<>(pageable.getPageNumber(), pageable.getPageSize());

        //年月 若为空，默认当月
        if (StringUtils.isBlank(dto.getFeeYearMonth())) {
            dto.setFeeYearMonth(DateUtil.format(new Date(),DateUtil.DEFAULT_YEAR_MONTH));
        }
        //组织编码 若为空，默认取当前登录人的组织编码
        if (StringUtils.isBlank(dto.getOrgCode())) {
            FacturerUserDetails loginUserDetails = loginUserService.getLoginDetails(FacturerUserDetails.class);
            if (!Objects.isNull(loginUserDetails)) {
                dto.setOrgCode(loginUserDetails.getOrgCode());
            }
        }
        selectDto.setYearMonthLy(dto.getFeeYearMonth());
        selectDto.setOrgCode(dto.getOrgCode());
        selectDto.setBudgetItemCode(dto.getBudgetItemCode());
        selectDto.setBudgetItemName(dto.getBudgetItemName());
        selectDto.setFeeSourceCode(dto.getFeeSourceCode());

        Page<SubComBudgetForecastVo> subBudgetForecastPage = this.subComBudgetForecastService.findSubBudgetForecastByConditions(pageable, selectDto);
        if (CollectionUtils.isEmpty(subBudgetForecastPage.getRecords())) {
            return resultPage;
        }

        if (!StringUtils.isBlank(dto.getCacheKey()) && Objects.isNull(itemCacheList)) {
            itemCacheList = subComActivityPlanItemCacheService.findCacheList(dto.getCacheKey());
        }

        Map<String, List<SubComActivityPlanItemDto>> itemCacheMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(itemCacheList)) {
            //过滤未填写费用金额的方案明细缓存
            itemCacheList = itemCacheList.stream().filter( i -> !Objects.isNull(i.getTotalCost())).collect(Collectors.toList());
            //按预算项目编码分组
            itemCacheMap = itemCacheList.stream().collect(Collectors.groupingBy(b -> b.getBudgetItemCode() + b.getFeeSourceCode()));
        }

        List<SubComActivityPlanBudgetVo> planBudgeList = new ArrayList<>(subBudgetForecastPage.getRecords().size());

        for (SubComBudgetForecastVo budgetForecast : subBudgetForecastPage.getRecords()) {
            SubComActivityPlanBudgetVo budgetVo = new SubComActivityPlanBudgetVo();
            budgetVo.setBudgetItemCode(budgetForecast.getBudgetItemCode());
            budgetVo.setBudgetItemName(budgetForecast.getBudgetItemName());
            budgetVo.setFeeSourceCode(budgetForecast.getFeeSourceCode());
            budgetVo.setYearMonthLy(budgetForecast.getYearMonthLy());
            budgetVo.setBudgetForecastCode(budgetForecast.getBudgetForecastCode());
            //期初金额
            BigDecimal initialAmount = Optional.ofNullable(budgetForecast.getFirstBudgetAmount()).orElse(BigDecimal.ZERO);
            budgetVo.setInitialAmount(initialAmount);
            //方案使用金额
            budgetVo.setPlanUseAmount(BigDecimal.ZERO);
            if (!org.springframework.util.CollectionUtils.isEmpty(itemCacheMap)) {
                List<SubComActivityPlanItemDto> planItemCacheList = itemCacheMap.get(budgetForecast.getBudgetItemCode()+budgetForecast.getFeeSourceCode());
                if (CollectionUtils.isNotEmpty(planItemCacheList)) {
                    BigDecimal planUseTotalCost = planItemCacheList.stream().map(SubComActivityPlanItemDto::getTotalCost).reduce(BigDecimal.ZERO, BigDecimal::add);
                    budgetVo.setPlanUseAmount(planUseTotalCost);
                }
            }

            //调用规划事件, 查询所有使用了该条预算的总预算金额
            SubPlanCallSubActivityDesignEventDto eventDto = new SubPlanCallSubActivityDesignEventDto();
            eventDto.setBudgetItemCode(budgetForecast.getBudgetItemCode());
            eventDto.setYearMonthLy(budgetForecast.getYearMonthLy());
            eventDto.setOrgCode(budgetForecast.getOrgCode());
            eventDto.setFeeSourceCode(budgetForecast.getFeeSourceCode());
            eventDto.setBusinessFormatCode(budgetForecast.getBusinessFormatCode());
            eventDto.setBusinessUnitCode(budgetForecast.getBusinessUnitCode());
            SerializableBiConsumer<SubPlanCallSubActivityDesignEventListener, SubPlanCallSubActivityDesignEventDto> findBudgetUsedAmountSum = SubPlanCallSubActivityDesignEventListener::findBudgetUsedAmountSum;
            EventResponse eventResponse = nebulaNetEventClient.directPublish(eventDto, SubPlanCallSubActivityDesignEventListener.class, findBudgetUsedAmountSum);
            if (!Objects.isNull(eventResponse)) {
                BudgetAmountResponse resp = (BudgetAmountResponse) eventResponse;
                budgetVo.setSubDesignUseAmount(resp.getBudgetAmount());
            }

            BigDecimal planUseAmount = Optional.ofNullable(budgetVo.getPlanUseAmount()).orElse(BigDecimal.ZERO);
            BigDecimal subDesignUseAmount = Optional.ofNullable(budgetVo.getSubDesignUseAmount()).orElse(BigDecimal.ZERO);
            //剩余可用金额 = 期初 - 方案使用 - 规划使用
            BigDecimal remainderAmount = initialAmount.subtract(planUseAmount).subtract(subDesignUseAmount);
            if (!FeeSourceEnum.AUTO_FEE.getCode().equals(budgetVo.getFeeSourceCode())) {
                Validate.isTrue(BigDecimal.ZERO.compareTo(remainderAmount) <= 0,budgetForecast.getBudgetItemCode()+"预算项目，剩余可用金额不足!");
            }
            budgetVo.setRemainderAmount(remainderAmount);

            planBudgeList.add(budgetVo);
        }

        resultPage.setRecords(planBudgeList);
        return resultPage;
    }
}
